/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.testhelper;

import com.github.kagkarlsson.scheduler.JdbcTaskRepository;
import com.github.kagkarlsson.scheduler.Scheduler;
import com.github.kagkarlsson.scheduler.TaskRepository;
import com.github.kagkarlsson.scheduler.TaskResolver;
import com.github.kagkarlsson.scheduler.task.OnStartup;
import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.testhelper.ManualScheduler;
import com.github.kagkarlsson.scheduler.testhelper.SettableClock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;

public class TestHelper {
    public static ManualSchedulerBuilder createManualScheduler(DataSource dataSource, Task<?> ... knownTasks) {
        return new ManualSchedulerBuilder(dataSource, Arrays.asList(knownTasks));
    }

    public static ManualSchedulerBuilder createManualScheduler(DataSource dataSource, List<Task<?>> knownTasks) {
        return new ManualSchedulerBuilder(dataSource, knownTasks);
    }

    private static class DirectExecutorService
    extends AbstractExecutorService {
        private DirectExecutorService() {
        }

        @Override
        public void shutdown() {
        }

        @Override
        public List<Runnable> shutdownNow() {
            return new ArrayList<Runnable>();
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public boolean isTerminated() {
            return false;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return true;
        }

        @Override
        public void execute(Runnable command) {
            command.run();
        }
    }

    public static class ManualSchedulerBuilder
    extends Scheduler.Builder {
        private SettableClock clock;

        public ManualSchedulerBuilder(DataSource dataSource, List<Task<?>> knownTasks) {
            super(dataSource, knownTasks);
        }

        public ManualSchedulerBuilder clock(SettableClock clock) {
            this.clock = clock;
            return this;
        }

        @Override
        public ManualScheduler build() {
            TaskResolver taskResolver = new TaskResolver(this.knownTasks);
            JdbcTaskRepository taskRepository = new JdbcTaskRepository(this.dataSource, this.tableName, taskResolver, this.schedulerName, this.serializer);
            return new ManualScheduler(this.clock, (TaskRepository)taskRepository, taskResolver, this.executorThreads, (ExecutorService)new DirectExecutorService(), this.schedulerName, this.waiter, this.heartbeatInterval, this.enableImmediateExecution, this.statsRegistry, (List<OnStartup>)this.startTasks);
        }

        public ManualScheduler start() {
            ManualScheduler scheduler = this.build();
            scheduler.start();
            return scheduler;
        }
    }
}

