/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler;

import com.github.kagkarlsson.scheduler.task.Task;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskResolver {
    private static final Logger LOG = LoggerFactory.getLogger(TaskResolver.class);
    private final Map<String, Task> taskMap;

    public TaskResolver(Task<?> ... knownTasks) {
        this(Arrays.asList(knownTasks));
    }

    public TaskResolver(List<Task<?>> knownTasks) {
        this.taskMap = knownTasks.stream().collect(Collectors.toMap(Task::getName, Function.identity()));
    }

    public Optional<Task> resolve(String taskName) {
        Task task = this.taskMap.get(taskName);
        if (task == null) {
            LOG.warn("Found execution with unknown task-name '{}'", (Object)taskName);
        }
        return Optional.ofNullable(task);
    }

    public void addTask(Task task) {
        this.taskMap.put(task.getName(), task);
    }
}

