/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task.helper;

import com.github.kagkarlsson.scheduler.task.CompletionHandler;
import com.github.kagkarlsson.scheduler.task.DeadExecutionHandler;
import com.github.kagkarlsson.scheduler.task.ExecutionContext;
import com.github.kagkarlsson.scheduler.task.FailureHandler;
import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.task.TaskInstance;
import com.github.kagkarlsson.scheduler.task.helper.OneTimeTask;
import com.github.kagkarlsson.scheduler.task.helper.RecurringTask;
import com.github.kagkarlsson.scheduler.task.schedule.Schedule;
import java.time.Duration;

public class ComposableTask {
    public static RecurringTask<Void> recurringTask(String name, Schedule schedule, final ExecutionHandlerWithExternalCompletion<Void> executionHandler) {
        return new RecurringTask<Void>(name, schedule, Void.class, null){

            @Override
            public void executeRecurringly(TaskInstance<Void> taskInstance, ExecutionContext executionContext) {
                executionHandler.execute(taskInstance, executionContext);
            }
        };
    }

    public static <T> OneTimeTask<T> onetimeTask(String name, Class<T> dataClass, final ExecutionHandlerWithExternalCompletion<T> executionHandler) {
        return new OneTimeTask<T>(name, dataClass){

            @Override
            public void executeOnce(TaskInstance<T> taskInstance, ExecutionContext executionContext) {
                executionHandler.execute(taskInstance, executionContext);
            }
        };
    }

    public static <T> Task<T> customTask(String name, Class<T> dataClass, final CompletionHandler<T> completionHandler, final ExecutionHandlerWithExternalCompletion<T> executionHandler) {
        return new Task<T>(name, dataClass, new FailureHandler.OnFailureRetryLater(Duration.ofMinutes(5L)), new DeadExecutionHandler.ReviveDeadExecution()){

            @Override
            public CompletionHandler<T> execute(TaskInstance<T> taskInstance, ExecutionContext executionContext) {
                executionHandler.execute(taskInstance, executionContext);
                return completionHandler;
            }
        };
    }

    public static <T> Task<T> customTask(String name, Class<T> dataClass, final CompletionHandler<T> completionHandler, FailureHandler<T> failureHandler, final ExecutionHandlerWithExternalCompletion<T> executionHandler) {
        return new Task<T>(name, dataClass, failureHandler, new DeadExecutionHandler.ReviveDeadExecution()){

            @Override
            public CompletionHandler<T> execute(TaskInstance<T> taskInstance, ExecutionContext executionContext) {
                executionHandler.execute(taskInstance, executionContext);
                return completionHandler;
            }
        };
    }

    public static interface ExecutionHandlerWithExternalCompletion<T> {
        public void execute(TaskInstance<T> var1, ExecutionContext var2);
    }
}

