/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler;

import com.github.kagkarlsson.scheduler.event.SchedulerListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RunAndLogErrors
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(RunAndLogErrors.class);
    private final Runnable toRun;
    private final SchedulerListener schedulerListener;

    public RunAndLogErrors(Runnable toRun, SchedulerListener schedulerListener) {
        this.toRun = toRun;
        this.schedulerListener = schedulerListener;
    }

    @Override
    public void run() {
        try {
            this.toRun.run();
        }
        catch (Throwable e) {
            LOG.error("Unhandled exception. Will keep running.", e);
            this.schedulerListener.onSchedulerEvent(SchedulerListener.SchedulerEventType.UNEXPECTED_ERROR);
        }
    }
}

