/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task.schedule;

import com.github.kagkarlsson.scheduler.task.schedule.Parser;
import com.github.kagkarlsson.scheduler.task.schedule.Schedule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class RegexBasedParser
implements Parser {
    private final Pattern pattern;
    private final List<String> examples;

    public RegexBasedParser(Pattern pattern, List<String> examples) {
        this.pattern = Objects.requireNonNull(pattern);
        this.examples = new ArrayList<String>(examples);
    }

    @Override
    public Optional<Schedule> parse(String scheduleString) {
        if (scheduleString == null) {
            return Optional.empty();
        }
        Matcher m = this.pattern.matcher(scheduleString);
        if (m.matches()) {
            return Optional.of(this.matchedSchedule(m));
        }
        return Optional.empty();
    }

    @Override
    public List<String> examples() {
        return Collections.unmodifiableList(this.examples);
    }

    protected abstract Schedule matchedSchedule(MatchResult var1);
}

