/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task.schedule;

import com.github.kagkarlsson.scheduler.task.helper.ScheduleAndData;
import com.github.kagkarlsson.scheduler.task.schedule.CronSchedule;
import com.github.kagkarlsson.scheduler.task.schedule.Schedule;
import java.time.ZoneId;

public class PersistentCronSchedule
implements ScheduleAndData {
    private final String cronPattern;
    private final String zoneId;
    private final Object data;

    public PersistentCronSchedule(String cronPattern) {
        this(cronPattern, ZoneId.systemDefault(), null);
    }

    public PersistentCronSchedule(String cronPattern, Object data) {
        this(cronPattern, ZoneId.systemDefault(), data);
    }

    public PersistentCronSchedule(String cronPattern, ZoneId zoneId) {
        this(cronPattern, zoneId, null);
    }

    public PersistentCronSchedule(String cronPattern, ZoneId zoneId, Object data) {
        this.cronPattern = cronPattern;
        this.zoneId = zoneId.getId();
        this.data = data;
    }

    public String toString() {
        return "PersistentCronSchedule pattern=" + this.cronPattern;
    }

    @Override
    public Schedule getSchedule() {
        return new CronSchedule(this.cronPattern, ZoneId.of(this.zoneId));
    }

    @Override
    public Object getData() {
        return this.data;
    }
}

