/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.jdbc;

import com.github.kagkarlsson.scheduler.jdbc.JdbcCustomization;
import com.github.kagkarlsson.scheduler.jdbc.JdbcTaskRepositoryContext;
import com.github.kagkarlsson.scheduler.task.Execution;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.List;
import java.util.Optional;

public class DefaultJdbcCustomization
implements JdbcCustomization {
    @Override
    public void setInstant(PreparedStatement p, int index, Instant value) throws SQLException {
        p.setTimestamp(index, value != null ? Timestamp.from(value) : null);
    }

    @Override
    public Instant getInstant(ResultSet rs, String columnName) throws SQLException {
        return Optional.ofNullable(rs.getTimestamp(columnName)).map(Timestamp::toInstant).orElse(null);
    }

    @Override
    public boolean supportsExplicitQueryLimitPart() {
        return false;
    }

    @Override
    public String getQueryLimitPart(int limit) {
        return "";
    }

    @Override
    public boolean supportsLockAndFetch() {
        return false;
    }

    @Override
    public List<Execution> lockAndFetch(JdbcTaskRepositoryContext ctx, Instant now, int limit) {
        throw new UnsupportedOperationException("lockAndFetch not supported for " + this.getClass().getName());
    }

    @Override
    public String getName() {
        return "Default";
    }
}

