/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler;

import com.github.kagkarlsson.scheduler.Clock;
import com.github.kagkarlsson.scheduler.ExecutorUtils;
import com.github.kagkarlsson.scheduler.PollingStrategyConfig;
import com.github.kagkarlsson.scheduler.Scheduler;
import com.github.kagkarlsson.scheduler.SchedulerName;
import com.github.kagkarlsson.scheduler.Serializer;
import com.github.kagkarlsson.scheduler.SystemClock;
import com.github.kagkarlsson.scheduler.TaskResolver;
import com.github.kagkarlsson.scheduler.Waiter;
import com.github.kagkarlsson.scheduler.jdbc.AutodetectJdbcCustomization;
import com.github.kagkarlsson.scheduler.jdbc.JdbcCustomization;
import com.github.kagkarlsson.scheduler.jdbc.JdbcTaskRepository;
import com.github.kagkarlsson.scheduler.logging.LogLevel;
import com.github.kagkarlsson.scheduler.stats.StatsRegistry;
import com.github.kagkarlsson.scheduler.task.OnStartup;
import com.github.kagkarlsson.scheduler.task.Task;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(SchedulerBuilder.class);
    public static final double UPPER_LIMIT_FRACTION_OF_THREADS_FOR_FETCH = 3.0;
    public static final Duration DEFAULT_POLLING_INTERVAL = Duration.ofSeconds(10L);
    public static final Duration DEFAULT_HEARTBEAT_INTERVAL = Duration.ofMinutes(5L);
    public static final Duration DEFAULT_DELETION_OF_UNRESOLVED_TASKS_DURATION = Duration.ofDays(14L);
    public static final Duration SHUTDOWN_MAX_WAIT = Duration.ofMinutes(30L);
    public static final PollingStrategyConfig DEFAULT_POLLING_STRATEGY = new PollingStrategyConfig(PollingStrategyConfig.Type.FETCH, 0.5, 3.0);
    public static final LogLevel DEFAULT_FAILURE_LOG_LEVEL = LogLevel.WARN;
    public static final boolean LOG_STACK_TRACE_ON_FAILURE = true;
    protected Clock clock = new SystemClock();
    protected final DataSource dataSource;
    protected SchedulerName schedulerName;
    protected int executorThreads = 10;
    protected final List<Task<?>> knownTasks = new ArrayList();
    protected final List<OnStartup> startTasks = new ArrayList<OnStartup>();
    protected Waiter waiter = new Waiter(DEFAULT_POLLING_INTERVAL, this.clock);
    protected StatsRegistry statsRegistry = StatsRegistry.NOOP;
    protected Duration heartbeatInterval = DEFAULT_HEARTBEAT_INTERVAL;
    protected Serializer serializer = Serializer.DEFAULT_JAVA_SERIALIZER;
    protected String tableName = "scheduled_tasks";
    protected boolean enableImmediateExecution = false;
    protected ExecutorService executorService;
    protected Duration deleteUnresolvedAfter = DEFAULT_DELETION_OF_UNRESOLVED_TASKS_DURATION;
    protected JdbcCustomization jdbcCustomization = null;
    protected Duration shutdownMaxWait = SHUTDOWN_MAX_WAIT;
    protected boolean commitWhenAutocommitDisabled = false;
    protected PollingStrategyConfig pollingStrategyConfig = DEFAULT_POLLING_STRATEGY;
    protected LogLevel logLevel = DEFAULT_FAILURE_LOG_LEVEL;
    protected boolean logStackTrace = true;
    private boolean registerShutdownHook = false;

    public SchedulerBuilder(DataSource dataSource, List<Task<?>> knownTasks) {
        this.dataSource = dataSource;
        this.knownTasks.addAll(knownTasks);
    }

    @SafeVarargs
    public final <T extends Task<?> & OnStartup> SchedulerBuilder startTasks(T ... startTasks) {
        return this.startTasks(Arrays.asList(startTasks));
    }

    public <T extends Task<?> & OnStartup> SchedulerBuilder startTasks(List<T> startTasks) {
        this.knownTasks.addAll(startTasks);
        this.startTasks.addAll(startTasks);
        return this;
    }

    public SchedulerBuilder pollingInterval(Duration pollingInterval) {
        this.waiter = new Waiter(pollingInterval, this.clock);
        return this;
    }

    public SchedulerBuilder heartbeatInterval(Duration duration) {
        this.heartbeatInterval = duration;
        return this;
    }

    public SchedulerBuilder threads(int numberOfThreads) {
        this.executorThreads = numberOfThreads;
        return this;
    }

    public SchedulerBuilder executorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public SchedulerBuilder statsRegistry(StatsRegistry statsRegistry) {
        this.statsRegistry = statsRegistry;
        return this;
    }

    public SchedulerBuilder schedulerName(SchedulerName schedulerName) {
        this.schedulerName = schedulerName;
        return this;
    }

    public SchedulerBuilder serializer(Serializer serializer) {
        this.serializer = serializer;
        return this;
    }

    public SchedulerBuilder tableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public SchedulerBuilder enableImmediateExecution() {
        this.enableImmediateExecution = true;
        return this;
    }

    public SchedulerBuilder deleteUnresolvedAfter(Duration deleteAfter) {
        this.deleteUnresolvedAfter = deleteAfter;
        return this;
    }

    public SchedulerBuilder jdbcCustomization(JdbcCustomization jdbcCustomization) {
        this.jdbcCustomization = jdbcCustomization;
        return this;
    }

    public SchedulerBuilder shutdownMaxWait(Duration shutdownMaxWait) {
        this.shutdownMaxWait = shutdownMaxWait;
        return this;
    }

    public SchedulerBuilder commitWhenAutocommitDisabled(boolean commitWhenAutocommitDisabled) {
        this.commitWhenAutocommitDisabled = commitWhenAutocommitDisabled;
        return this;
    }

    public SchedulerBuilder pollUsingFetchAndLockOnExecute(double lowerLimitFractionOfThreads, double executionsPerBatchFractionOfThreads) {
        this.pollingStrategyConfig = new PollingStrategyConfig(PollingStrategyConfig.Type.FETCH, lowerLimitFractionOfThreads, executionsPerBatchFractionOfThreads);
        return this;
    }

    public SchedulerBuilder pollUsingLockAndFetch(double lowerLimitFractionOfThreads, double upperLimitFractionOfThreads) {
        this.pollingStrategyConfig = new PollingStrategyConfig(PollingStrategyConfig.Type.LOCK_AND_FETCH, lowerLimitFractionOfThreads, upperLimitFractionOfThreads);
        return this;
    }

    public SchedulerBuilder failureLogging(LogLevel logLevel, boolean logStackTrace) {
        if (logLevel == null) {
            throw new IllegalArgumentException("Log level must not be null");
        }
        this.logLevel = logLevel;
        this.logStackTrace = logStackTrace;
        return this;
    }

    public SchedulerBuilder registerShutdownHook() {
        this.registerShutdownHook = true;
        return this;
    }

    public Scheduler build() {
        if (this.schedulerName == null) {
            this.schedulerName = new SchedulerName.Hostname();
        }
        TaskResolver taskResolver = new TaskResolver(this.statsRegistry, this.clock, this.knownTasks);
        JdbcCustomization jdbcCustomization = Optional.ofNullable(this.jdbcCustomization).orElseGet(() -> new AutodetectJdbcCustomization(this.dataSource));
        JdbcTaskRepository schedulerTaskRepository = new JdbcTaskRepository(this.dataSource, true, jdbcCustomization, this.tableName, taskResolver, this.schedulerName, this.serializer);
        JdbcTaskRepository clientTaskRepository = new JdbcTaskRepository(this.dataSource, this.commitWhenAutocommitDisabled, jdbcCustomization, this.tableName, taskResolver, this.schedulerName, this.serializer);
        ExecutorService candidateExecutorService = this.executorService;
        if (candidateExecutorService == null) {
            candidateExecutorService = Executors.newFixedThreadPool(this.executorThreads, ExecutorUtils.defaultThreadFactoryWithPrefix("db-scheduler-"));
        }
        LOG.info("Creating scheduler with configuration: threads={}, pollInterval={}s, heartbeat={}s enable-immediate-execution={}, table-name={}, name={}", new Object[]{this.executorThreads, this.waiter.getWaitDuration().getSeconds(), this.heartbeatInterval.getSeconds(), this.enableImmediateExecution, this.tableName, this.schedulerName.getName()});
        Scheduler scheduler = new Scheduler(this.clock, schedulerTaskRepository, clientTaskRepository, taskResolver, this.executorThreads, candidateExecutorService, this.schedulerName, this.waiter, this.heartbeatInterval, this.enableImmediateExecution, this.statsRegistry, this.pollingStrategyConfig, this.deleteUnresolvedAfter, this.shutdownMaxWait, this.logLevel, this.logStackTrace, this.startTasks);
        if (this.registerShutdownHook) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                LOG.info("Received shutdown signal.");
                scheduler.stop();
            }));
        }
        return scheduler;
    }
}

