/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task;

import com.github.kagkarlsson.scheduler.task.Schedule;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class Daily
implements Schedule {
    private final List<LocalTime> times;

    public Daily(LocalTime ... times) {
        this(Arrays.asList(times));
    }

    public Daily(List<LocalTime> times) {
        if (times.size() < 1) {
            throw new IllegalArgumentException("times cannot be empty");
        }
        this.times = times.stream().sorted().collect(Collectors.toList());
    }

    @Override
    public LocalDateTime getNextExecutionTime(LocalDateTime timeDone) {
        for (LocalTime time : this.times) {
            if (!time.isAfter(timeDone.toLocalTime())) continue;
            return LocalDateTime.from(timeDone.toLocalDate().atTime(time));
        }
        return timeDone.toLocalDate().plusDays(1L).atTime(this.times.get(0));
    }
}

