/*
 * Decompiled with CFR 0.152.
 */
package org.jsfr.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.Reader;
import org.jsfr.json.AbstractSurfer;
import org.jsfr.json.JacksonProvider;
import org.jsfr.json.JsonProvider;
import org.jsfr.json.SurfingContext;
import org.jsfr.json.exception.JsonSurfingException;
import org.json.simple.parser.ParseException;

public class JacksonSurfer
extends AbstractSurfer {
    public JacksonSurfer() {
        super((JsonProvider)new JacksonProvider());
    }

    public JacksonSurfer(JsonProvider jsonProvider) {
        super(jsonProvider);
    }

    public void surf(Reader reader, SurfingContext context) {
        this.ensureJsonProvider(context);
        try {
            JsonFactory f = new JsonFactory();
            JsonParser jp = f.createParser(reader);
            context.startJSON();
            block18: while (true) {
                JsonToken token;
                if ((token = jp.nextToken()) == null) {
                    context.endJSON();
                    return;
                }
                switch (token) {
                    case NOT_AVAILABLE: {
                        return;
                    }
                    case START_OBJECT: {
                        if (context.startObject()) break;
                        return;
                    }
                    case END_OBJECT: {
                        if (!context.endObject()) {
                            return;
                        }
                        if (jp.getCurrentName() == null || context.endObjectEntry()) continue block18;
                        return;
                    }
                    case START_ARRAY: {
                        if (context.startArray()) break;
                        return;
                    }
                    case END_ARRAY: {
                        if (!context.endArray()) {
                            return;
                        }
                        if (jp.getCurrentName() == null || context.endObjectEntry()) continue block18;
                        return;
                    }
                    case FIELD_NAME: {
                        if (context.startObjectEntry(jp.getCurrentName())) break;
                        return;
                    }
                    case VALUE_EMBEDDED_OBJECT: {
                        throw new IllegalStateException("Unexpected token");
                    }
                    case VALUE_STRING: {
                        if (!context.primitive(this.jsonProvider.primitive(jp.getText()))) {
                            return;
                        }
                        if (jp.getCurrentName() == null || context.endObjectEntry()) continue block18;
                        return;
                    }
                    case VALUE_NUMBER_INT: {
                        if (!context.primitive(this.jsonProvider.primitive(jp.getIntValue()))) {
                            return;
                        }
                        if (jp.getCurrentName() == null || context.endObjectEntry()) continue block18;
                        return;
                    }
                    case VALUE_NUMBER_FLOAT: {
                        if (!context.primitive(this.jsonProvider.primitive(jp.getDoubleValue()))) {
                            return;
                        }
                        if (jp.getCurrentName() == null || context.endObjectEntry()) continue block18;
                        return;
                    }
                    case VALUE_TRUE: {
                        if (!context.primitive(this.jsonProvider.primitive(true))) {
                            return;
                        }
                        if (jp.getCurrentName() == null || context.endObjectEntry()) continue block18;
                        return;
                    }
                    case VALUE_FALSE: {
                        if (!context.primitive(this.jsonProvider.primitive(false))) {
                            return;
                        }
                        if (jp.getCurrentName() == null || context.endObjectEntry()) continue block18;
                        return;
                    }
                    case VALUE_NULL: {
                        if (!context.primitive(this.jsonProvider.primitiveNull())) {
                            return;
                        }
                        if (jp.getCurrentName() == null || context.endObjectEntry()) continue block18;
                        return;
                    }
                }
            }
        }
        catch (IOException e) {
            throw new JsonSurfingException((Throwable)e);
        }
        catch (ParseException e) {
            throw new JsonSurfingException((Throwable)e);
        }
    }
}

