/*
 * Decompiled with CFR 0.152.
 */
package org.jsfr.json;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.Reader;
import java.io.StringReader;
import org.jsfr.json.AbstractPrimitiveHolder;
import org.jsfr.json.JsonParserAdapter;
import org.jsfr.json.PrimitiveHolder;
import org.jsfr.json.SurfingContext;
import org.jsfr.json.provider.JsonProvider;

public class GsonParser
implements JsonParserAdapter {
    public static final GsonParser INSTANCE = new GsonParser();

    private GsonParser() {
    }

    public void parse(Reader reader, SurfingContext context) {
        try {
            final JsonReader jsonReader = new JsonReader(reader);
            final JsonProvider jsonProvider = context.getConfig().getJsonProvider();
            AbstractPrimitiveHolder stringHolder = new AbstractPrimitiveHolder(context.getConfig()){

                public Object doGetValue() throws Exception {
                    return jsonProvider.primitive(jsonReader.nextString());
                }

                public void doSkipValue() throws Exception {
                    jsonReader.skipValue();
                }
            };
            AbstractPrimitiveHolder numberHolder = new AbstractPrimitiveHolder(context.getConfig()){

                public Object doGetValue() throws Exception {
                    return jsonProvider.primitive(jsonReader.nextDouble());
                }

                public void doSkipValue() throws Exception {
                    jsonReader.skipValue();
                }
            };
            AbstractPrimitiveHolder booleanHolder = new AbstractPrimitiveHolder(context.getConfig()){

                public Object doGetValue() throws Exception {
                    return jsonProvider.primitive(jsonReader.nextBoolean());
                }

                public void doSkipValue() throws Exception {
                    jsonReader.skipValue();
                }
            };
            AbstractPrimitiveHolder nullHolder = new AbstractPrimitiveHolder(context.getConfig()){

                public Object doGetValue() throws Exception {
                    jsonReader.nextNull();
                    return jsonProvider.primitiveNull();
                }

                public void doSkipValue() throws Exception {
                    jsonReader.skipValue();
                }
            };
            context.startJSON();
            while (!context.isStopped()) {
                JsonToken token = jsonReader.peek();
                switch (token) {
                    case BEGIN_ARRAY: {
                        jsonReader.beginArray();
                        context.startArray();
                        break;
                    }
                    case END_ARRAY: {
                        jsonReader.endArray();
                        context.endArray();
                        break;
                    }
                    case BEGIN_OBJECT: {
                        jsonReader.beginObject();
                        context.startObject();
                        break;
                    }
                    case END_OBJECT: {
                        jsonReader.endObject();
                        context.endObject();
                        break;
                    }
                    case NAME: {
                        String name = jsonReader.nextName();
                        context.startObjectEntry(name);
                        break;
                    }
                    case STRING: {
                        stringHolder.init();
                        context.primitive((PrimitiveHolder)stringHolder);
                        stringHolder.skipValue();
                        break;
                    }
                    case NUMBER: {
                        numberHolder.init();
                        context.primitive((PrimitiveHolder)numberHolder);
                        numberHolder.skipValue();
                        break;
                    }
                    case BOOLEAN: {
                        booleanHolder.init();
                        context.primitive((PrimitiveHolder)booleanHolder);
                        booleanHolder.skipValue();
                        break;
                    }
                    case NULL: {
                        nullHolder.init();
                        context.primitive((PrimitiveHolder)nullHolder);
                        nullHolder.skipValue();
                        break;
                    }
                    case END_DOCUMENT: {
                        context.endJSON();
                        return;
                    }
                }
            }
        }
        catch (Exception e) {
            context.getConfig().getErrorHandlingStrategy().handleParsingException(e);
        }
    }

    public void parse(String json, SurfingContext context) {
        this.parse(new StringReader(json), context);
    }
}

