/*
 * Decompiled with CFR 0.152.
 */
package org.jsfr.json;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.Reader;
import java.util.Stack;
import org.jsfr.json.AbstractSurfer;
import org.jsfr.json.GsonProvider;
import org.jsfr.json.JsonProvider;
import org.jsfr.json.SurfingContext;
import org.jsfr.json.exception.JsonSurfingException;
import org.json.simple.parser.ParseException;

public class GsonSurfer
extends AbstractSurfer {
    public GsonSurfer() {
        super((JsonProvider)new GsonProvider());
    }

    public GsonSurfer(JsonProvider jsonProvider) {
        super(jsonProvider);
    }

    public void surf(Reader reader, SurfingContext context) {
        this.ensureJsonProvider(context);
        try {
            JsonReader jsonReader = new JsonReader(reader);
            Stack<EntryType> entryStack = new Stack<EntryType>();
            entryStack.push(EntryType.ROOT);
            context.startJSON();
            while (true) {
                JsonToken token = jsonReader.peek();
                switch (token) {
                    case BEGIN_ARRAY: {
                        jsonReader.beginArray();
                        if (context.startArray()) break;
                        return;
                    }
                    case END_ARRAY: {
                        jsonReader.endArray();
                        if (!context.endArray()) {
                            return;
                        }
                        if (entryStack.peek() != EntryType.ARRAY) break;
                        if (!context.endObjectEntry()) {
                            return;
                        }
                        entryStack.pop();
                        break;
                    }
                    case BEGIN_OBJECT: {
                        jsonReader.beginObject();
                        if (context.startObject()) break;
                        return;
                    }
                    case END_OBJECT: {
                        jsonReader.endObject();
                        if (!context.endObject()) {
                            return;
                        }
                        if (entryStack.peek() != EntryType.OBJECT) break;
                        if (!context.endObjectEntry()) {
                            return;
                        }
                        entryStack.pop();
                        break;
                    }
                    case NAME: {
                        String name = jsonReader.nextName();
                        if (!context.startObjectEntry(name)) {
                            return;
                        }
                        JsonToken peek = jsonReader.peek();
                        if (peek == JsonToken.STRING || peek == JsonToken.BOOLEAN || peek == JsonToken.NUMBER || peek == JsonToken.NULL) {
                            entryStack.push(EntryType.PRIMITIVE);
                            break;
                        }
                        if (peek == JsonToken.BEGIN_OBJECT) {
                            entryStack.push(EntryType.OBJECT);
                            break;
                        }
                        if (peek != JsonToken.BEGIN_ARRAY) break;
                        entryStack.push(EntryType.ARRAY);
                        break;
                    }
                    case STRING: {
                        String s = jsonReader.nextString();
                        if (!context.primitive(this.jsonProvider.primitive(s))) {
                            return;
                        }
                        if (entryStack.peek() != EntryType.PRIMITIVE) break;
                        if (!context.endObjectEntry()) {
                            return;
                        }
                        entryStack.pop();
                        break;
                    }
                    case NUMBER: {
                        double n = jsonReader.nextDouble();
                        if (!context.primitive(this.jsonProvider.primitive(n))) {
                            return;
                        }
                        if (entryStack.peek() != EntryType.PRIMITIVE) break;
                        if (!context.endObjectEntry()) {
                            return;
                        }
                        entryStack.pop();
                        break;
                    }
                    case BOOLEAN: {
                        boolean b = jsonReader.nextBoolean();
                        if (!context.primitive(this.jsonProvider.primitive(b))) {
                            return;
                        }
                        if (entryStack.peek() != EntryType.PRIMITIVE) break;
                        if (!context.endObjectEntry()) {
                            return;
                        }
                        entryStack.pop();
                        break;
                    }
                    case NULL: {
                        jsonReader.nextNull();
                        if (!context.primitive(this.jsonProvider.primitiveNull())) {
                            return;
                        }
                        if (entryStack.peek() != EntryType.PRIMITIVE) break;
                        if (!context.endObjectEntry()) {
                            return;
                        }
                        entryStack.pop();
                        break;
                    }
                    case END_DOCUMENT: {
                        context.endJSON();
                        entryStack.clear();
                        return;
                    }
                }
            }
        }
        catch (IOException e) {
            throw new JsonSurfingException((Throwable)e);
        }
        catch (ParseException e) {
            throw new JsonSurfingException((Throwable)e);
        }
    }

    private static enum EntryType {
        ROOT,
        OBJECT,
        ARRAY,
        PRIMITIVE;

    }
}

