/*
 * Decompiled with CFR 0.152.
 */
package org.jsfr.json;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.JSONLexerBase;
import com.alibaba.fastjson.parser.JSONReaderScanner;
import com.alibaba.fastjson.parser.JSONScanner;
import java.io.Reader;
import org.jsfr.json.JsonParserAdapter;
import org.jsfr.json.PrimitiveHolder;
import org.jsfr.json.StaticPrimitiveHolder;
import org.jsfr.json.SurfingContext;

public class FastJsonParser
implements JsonParserAdapter {
    public static final FastJsonParser INSTANCE = new FastJsonParser();

    private FastJsonParser() {
    }

    public void parse(Reader reader, SurfingContext context) {
        this.doParse((JSONLexerBase)new JSONReaderScanner(reader), context);
    }

    public void parse(String json, SurfingContext context) {
        this.doParse((JSONLexerBase)new JSONScanner(json), context);
    }

    private void doParse(JSONLexerBase lexer, SurfingContext context) {
        try {
            StaticPrimitiveHolder staticPrimitiveHolder = new StaticPrimitiveHolder();
            context.startJSON();
            String tempString = null;
            do {
                lexer.nextToken();
                int token = lexer.token();
                if (tempString != null) {
                    if (token == 17) {
                        context.startObjectEntry(tempString);
                    } else {
                        context.primitive((PrimitiveHolder)staticPrimitiveHolder.withValue((Object)tempString));
                    }
                    tempString = null;
                }
                switch (token) {
                    case 9: 
                    case 16: 
                    case 17: 
                    case 21: 
                    case 22: {
                        break;
                    }
                    case 14: {
                        context.startArray();
                        break;
                    }
                    case 15: {
                        context.endArray();
                        break;
                    }
                    case 12: {
                        context.startObject();
                        break;
                    }
                    case 13: {
                        context.endObject();
                        break;
                    }
                    case 2: {
                        context.primitive((PrimitiveHolder)staticPrimitiveHolder.withValue((Object)lexer.longValue()));
                        break;
                    }
                    case 3: {
                        context.primitive((PrimitiveHolder)staticPrimitiveHolder.withValue((Object)lexer.doubleValue()));
                        break;
                    }
                    case 4: 
                    case 18: {
                        tempString = lexer.stringVal();
                        break;
                    }
                    case 8: 
                    case 23: {
                        context.primitive((PrimitiveHolder)staticPrimitiveHolder.withValue(null));
                        break;
                    }
                    case 6: {
                        context.primitive((PrimitiveHolder)staticPrimitiveHolder.withValue((Object)true));
                        break;
                    }
                    case 7: {
                        context.primitive((PrimitiveHolder)staticPrimitiveHolder.withValue((Object)false));
                        break;
                    }
                    case 20: {
                        context.endJSON();
                        break;
                    }
                    default: {
                        throw new JSONException("syntax error, " + lexer.info());
                    }
                }
            } while (!lexer.isEOF() && !context.isStopped());
            if (tempString != null) {
                context.primitive((PrimitiveHolder)staticPrimitiveHolder.withValue((Object)tempString));
            }
        }
        catch (Exception e) {
            context.getConfig().getErrorHandlingStrategy().handleParsingException(e);
        }
    }
}

