/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonzou.jmockdata.mocker;

import com.github.jsonzou.jmockdata.DataConfig;
import com.github.jsonzou.jmockdata.Mocker;
import com.github.jsonzou.jmockdata.mocker.BaseMocker;
import com.github.jsonzou.jmockdata.util.RandomUtils;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ArrayMocker
implements Mocker<Object> {
    private Type type;

    ArrayMocker(Type type) {
        this.type = type;
    }

    @Override
    public Object mock(DataConfig mockConfig) {
        if (this.type instanceof GenericArrayType) {
            return this.createGenericArray(mockConfig);
        }
        return this.array(mockConfig);
    }

    private Object array(DataConfig mockConfig) {
        int size = RandomUtils.nextSize(mockConfig.sizeRange()[0], mockConfig.sizeRange()[1]);
        Class<?> componentClass = ((Class)this.type).getComponentType();
        Object result = Array.newInstance(componentClass, size);
        BaseMocker baseMocker = new BaseMocker(componentClass, new Type[0]);
        for (int index = 0; index < size; ++index) {
            Array.set(result, index, baseMocker.mock(mockConfig));
        }
        return result;
    }

    private Object createGenericArray(DataConfig mockConfig) {
        GenericArrayType genericArrayType = (GenericArrayType)this.type;
        Map<Integer, Map<Class, Type[]>> map = this.map(mockConfig, genericArrayType, 0);
        Map.Entry<Integer, Map<Class, Type[]>> entry = map.entrySet().iterator().next();
        Map.Entry<Class, Type[]> baseEntry = entry.getValue().entrySet().iterator().next();
        int[] dimensions = new int[entry.getKey().intValue()];
        for (int index = 0; index < dimensions.length; ++index) {
            dimensions[index] = RandomUtils.nextSize(mockConfig.sizeRange()[0], mockConfig.sizeRange()[1]);
        }
        ArrayList<Object> list = new ArrayList<Object>(dimensions.length);
        Class<?> clazz = baseEntry.getKey();
        for (int index = dimensions.length - 1; index >= 0; --index) {
            Object array = Array.newInstance(clazz, dimensions[index]);
            list.add(array);
            clazz = array.getClass();
        }
        Object baseResult = new BaseMocker(baseEntry.getKey(), baseEntry.getValue()).mock(mockConfig);
        for (int i = 0; i < list.size(); ++i) {
            Object array = list.get(i);
            for (int j = 0; j < dimensions[dimensions.length - i - 1]; ++j) {
                Array.set(array, j, baseResult);
            }
            baseResult = array;
        }
        return baseResult;
    }

    private Map<Integer, Map<Class, Type[]>> map(DataConfig mockConfig, GenericArrayType genericArrayType, int dimension) {
        HashMap<Integer, Map<Class, Type[]>> result = new HashMap<Integer, Map<Class, Type[]>>();
        Type componentType = genericArrayType.getGenericComponentType();
        ++dimension;
        if (componentType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)componentType;
            HashMap<Class, Type[]> map = new HashMap<Class, Type[]>();
            map.put((Class)parameterizedType.getRawType(), parameterizedType.getActualTypeArguments());
            result.put(dimension, map);
            return result;
        }
        if (componentType instanceof GenericArrayType) {
            return this.map(mockConfig, (GenericArrayType)componentType, dimension);
        }
        if (componentType instanceof TypeVariable) {
            HashMap<Class, Object> map = new HashMap<Class, Object>();
            map.put((Class)mockConfig.globalConfig().getVariableType(((TypeVariable)componentType).getName()), null);
            result.put(dimension, map);
            return result;
        }
        HashMap<Class, Object> map = new HashMap<Class, Object>();
        map.put((Class)componentType, null);
        result.put(dimension, map);
        return result;
    }
}

