/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsontemplate.valueproducer;

import com.github.jsontemplate.jsonbuild.JsonBooleanNode;
import com.github.jsontemplate.jsonbuild.supplier.ListParamSupplier;
import com.github.jsontemplate.valueproducer.AbstractValueProducer;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class BooleanValueProducer
extends AbstractValueProducer<JsonBooleanNode> {
    public static final String TYPE_NAME = "b";

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public JsonBooleanNode produce() {
        return new JsonBooleanNode(() -> new Random().nextBoolean());
    }

    @Override
    public JsonBooleanNode produce(String value) {
        boolean parsedBoolean = Boolean.parseBoolean(value);
        return new JsonBooleanNode(() -> parsedBoolean);
    }

    @Override
    public JsonBooleanNode produce(List<String> valueList) {
        List parsedValueList = valueList.stream().map(Boolean::parseBoolean).collect(Collectors.toList());
        return new JsonBooleanNode((Supplier<Boolean>)new ListParamSupplier<Boolean>(parsedValueList));
    }
}

