/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsontemplate.valueproducer;

import com.github.jsontemplate.jsonbuild.JsonNode;
import com.github.jsontemplate.valueproducer.IValueProducer;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class AbstractValueProducer<T extends JsonNode>
implements IValueProducer<T> {
    @Override
    public T produce() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T produce(String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T produce(List<String> valueList) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T produce(Map<String, String> paramMap) {
        throw new UnsupportedOperationException();
    }

    protected Integer pickIntegerParam(Map<String, String> paramMap, String paramName) {
        return this.pickParamValue(paramMap, paramName, Integer::parseInt);
    }

    protected Float pickFloatParam(Map<String, String> paramMap, String paramName) {
        return this.pickParamValue(paramMap, paramName, Float::parseFloat);
    }

    protected Boolean pickBooleanParam(Map<String, String> paramMap, String paramName) {
        return this.pickParamValue(paramMap, paramName, Boolean::parseBoolean);
    }

    protected String pickStringParam(Map<String, String> paramMap, String paramName) {
        return paramMap.get(paramName);
    }

    private <R> R pickParamValue(Map<String, String> paramMap, String paramName, Function<String, R> parser) {
        String paramValue = paramMap.remove(paramName);
        if (paramValue != null) {
            return parser.apply(paramValue);
        }
        return null;
    }

    protected int randomIntInRange(int min, int max) {
        return ThreadLocalRandom.current().nextInt(min, max + 1);
    }

    protected float randomFloatInRange(float min, float max) {
        return min + new Random().nextFloat() * (max - min);
    }

    protected void validateParamMap(Map<String, String> paramMap) {
        if (paramMap.size() > 0) {
            String unexpectedArgument = paramMap.keySet().stream().collect(Collectors.joining(", "));
            throw new IllegalArgumentException("Arguments [" + unexpectedArgument + "] is not supported in " + this.getClass().getName());
        }
    }

    protected void shouldBePositive(int number, String fieldName) {
        if (number < 0) {
            throw new IllegalArgumentException("[" + fieldName + "] should be positive.");
        }
    }

    protected void shouldBeInAscOrder(int min, int max, String field1, String field2) {
        if (min > max) {
            throw new IllegalArgumentException("[" + field1 + "] should be less than [" + field2 + "].");
        }
    }

    protected void shouldBeInAscOrder(float min, float max, String field1, String field2) {
        if (min > max) {
            throw new IllegalArgumentException("[" + field1 + "] should be less than [" + field2 + "].");
        }
    }
}

