/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsontemplate.jsonbuild;

import com.github.jsontemplate.jsonbuild.JsonNode;
import com.github.jsontemplate.jsonbuild.JsonNodeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;

public final class JsonArrayNode
implements JsonNode {
    private List<JsonNode> children = new LinkedList<JsonNode>();
    private JsonNode defaultNode;
    private Integer size;
    private Integer max;
    private Integer min;

    public static JsonArrayNode of(Collection<?> collection) {
        JsonArrayNode jsonArrayNode = new JsonArrayNode();
        collection.stream().map(JsonNode::of).forEach(jsonArrayNode::addNode);
        return jsonArrayNode;
    }

    public static JsonArrayNode of(Object[] objects) {
        JsonArrayNode jsonArrayNode = new JsonArrayNode();
        Arrays.stream(objects).map(JsonNode::of).forEach(jsonArrayNode::addNode);
        return jsonArrayNode;
    }

    public void addNode(JsonNode jsonNode) {
        this.children.add(jsonNode);
    }

    public void setDefaultNode(JsonNode jsonNode) {
        this.defaultNode = jsonNode;
    }

    public void setParameters(String singleParam) {
        this.size = Integer.parseInt(singleParam);
    }

    public void setParameters(List<String> listParam) {
        this.min = Integer.parseInt(listParam.get(0));
        this.max = Integer.parseInt(listParam.get(1));
    }

    public void setParameters(Map<String, String> mapParam) {
        this.size = this.readParam(mapParam, "size");
        this.max = this.readParam(mapParam, "max");
        this.min = this.readParam(mapParam, "min");
        if (this.size == null) {
            if (this.min != null && this.max == null) {
                this.max = 2 * this.min;
            } else if (this.min == null && this.max != null) {
                this.min = 0;
            }
        }
    }

    private List<JsonNode> prepareAdditionalNodeList() {
        if (this.size != null) {
            return this.addtionalNodeList(this.size);
        }
        if (this.max != null && this.children.size() < this.max) {
            int randomSize = new Random().nextInt(this.max - this.min + 1) + this.min;
            return this.addtionalNodeList(randomSize);
        }
        return Collections.emptyList();
    }

    private List<JsonNode> addtionalNodeList(int size) {
        if (size > this.children.size()) {
            int amount = size - this.children.size();
            ArrayList<JsonNode> list = new ArrayList<JsonNode>(amount);
            if (this.defaultNode != null) {
                for (int i = 0; i < amount; ++i) {
                    list.add(this.defaultNode);
                }
            }
            return list;
        }
        return Collections.emptyList();
    }

    private Integer readParam(Map<String, String> mapParam, String key) {
        String value = mapParam.get(key);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return null;
    }

    @Override
    public String compactString() {
        List<JsonNode> printChildren = this.prepareChildrenToPrint();
        String joinedChildren = printChildren.stream().map(JsonNode::compactString).collect(Collectors.joining(","));
        return "[" + joinedChildren + "]";
    }

    @Override
    public String prettyString(int indentation) {
        String childrenSpaces = JsonNodeUtils.makeIdentation(indentation + 1);
        List<JsonNode> printChildren = this.prepareChildrenToPrint();
        String joinedIdentChildren = printChildren.stream().map(child -> childrenSpaces + child.prettyString(indentation + 1)).collect(Collectors.joining(",\n"));
        String spaces = JsonNodeUtils.makeIdentation(indentation);
        return "[\n" + joinedIdentChildren + "\n" + spaces + "]";
    }

    private List<JsonNode> prepareChildrenToPrint() {
        ArrayList<JsonNode> printChildren = new ArrayList<JsonNode>();
        printChildren.addAll(this.children);
        List<JsonNode> additionalNodeList = this.prepareAdditionalNodeList();
        printChildren.addAll(additionalNodeList);
        return printChildren;
    }
}

