/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsontemplate.jsonbuild;

import com.github.jsontemplate.jsonbuild.JsonNode;
import com.github.jsontemplate.jsonbuild.JsonNodeUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;

public final class JsonObjectNode
implements JsonNode {
    private Map<String, JsonNode> children = new LinkedHashMap<String, JsonNode>();

    public static JsonObjectNode of(Map<String, ?> valueMap) {
        JsonObjectNode jsonObjectNode = new JsonObjectNode();
        valueMap.forEach((key, value) -> jsonObjectNode.putNode((String)key, JsonNode.of(value)));
        return jsonObjectNode;
    }

    public void putNode(String key, JsonNode node) {
        this.children.put(key, node);
    }

    @Override
    public String compactString() {
        String joinedChildren = this.children.entrySet().stream().map(entry -> "\"" + (String)entry.getKey() + "\":" + ((JsonNode)entry.getValue()).compactString()).collect(Collectors.joining(","));
        return "{" + joinedChildren + "}";
    }

    @Override
    public String prettyString(int indentation) {
        String childSpaces = JsonNodeUtils.makeIdentation(indentation + 1);
        String joinedIdentChildren = this.children.entrySet().stream().map(entry -> childSpaces + "\"" + (String)entry.getKey() + "\" : " + ((JsonNode)entry.getValue()).prettyString(indentation + 1)).collect(Collectors.joining(",\n"));
        String spaces = JsonNodeUtils.makeIdentation(indentation);
        return "{\n" + joinedIdentChildren + "\n" + spaces + "}";
    }
}

