/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsdevel.testng.selenium;

import com.github.jsdevel.testng.selenium.MethodContextImpl;
import com.github.jsdevel.testng.selenium.PageFactory;
import com.github.jsdevel.testng.selenium.PageFactoryProxy;
import com.github.jsdevel.testng.selenium.annotations.driverconfig.UserAgent;
import com.github.jsdevel.testng.selenium.annotations.drivers.Chrome;
import com.github.jsdevel.testng.selenium.annotations.drivers.Firefox;
import com.github.jsdevel.testng.selenium.annotations.drivers.InternetExplorer;
import com.github.jsdevel.testng.selenium.annotations.screensizes.Desktop;
import com.github.jsdevel.testng.selenium.annotations.screensizes.LargeDesktop;
import com.github.jsdevel.testng.selenium.annotations.screensizes.Phone;
import com.github.jsdevel.testng.selenium.annotations.screensizes.Tablet;
import com.github.jsdevel.testng.selenium.environment.EnvironmentConfig;
import com.github.jsdevel.testng.selenium.exceptions.MissingPageFactoryException;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import net.anthavio.phanbedder.Phanbedder;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

class AbsractSuiteHelpers {
    private static final File phantomBinary = Phanbedder.unpack();

    AbsractSuiteHelpers() {
    }

    static <PF extends PageFactory> void addPageFactory(MethodContextImpl context) {
        ParameterizedType abstractSuite;
        Class<?> suite = context.method.getDeclaringClass();
        try {
            abstractSuite = (ParameterizedType)suite.getGenericSuperclass();
        }
        catch (ClassCastException e) {
            throw new MissingPageFactoryException("AbstractSuite must receive Type parameters I.E. class MySuite extends AbstractSuite<MyPageFactory>.  None were given in " + suite.getName());
        }
        Class pageFactoryClass = (Class)abstractSuite.getActualTypeArguments()[0];
        context.setPageFactory((PageFactory)PageFactoryProxy.newInstance(pageFactoryClass, context));
    }

    static void addScreensize(MethodContextImpl context) {
        Method method = context.method;
        WebDriver driver = context.getWebDriver();
        Dimension testConfiguredDimension = AbsractSuiteHelpers.getDimension(method, context);
        if (testConfiguredDimension == null) {
            try {
                testConfiguredDimension = AbsractSuiteHelpers.getDimension(ScreenSizeHelper.class.getDeclaredMethod(EnvironmentConfig.SCREENSIZE.toLowerCase(), new Class[0]), context);
            }
            catch (NoSuchMethodException | SecurityException exception) {
                // empty catch block
            }
        }
        if (testConfiguredDimension != null) {
            driver.manage().window().setSize(testConfiguredDimension);
        }
    }

    static synchronized void addWebDriver(MethodContextImpl context) {
        Method method = context.method;
        if (method.isAnnotationPresent(Chrome.class)) {
            AbsractSuiteHelpers.addChromeDriver(context);
        } else if (method.isAnnotationPresent(Firefox.class)) {
            AbsractSuiteHelpers.addFirefoxDriver(context);
        } else if (method.isAnnotationPresent(InternetExplorer.class)) {
            AbsractSuiteHelpers.addInternetExplorerDriver(context);
        } else {
            AbsractSuiteHelpers.addPhantomJSDriver(context);
        }
    }

    static void addUserAgent(MethodContextImpl context) {
        Method method = context.method;
        if (method.isAnnotationPresent(UserAgent.class)) {
            context.setUserAgent(method.getAnnotation(UserAgent.class).value());
        }
    }

    private static void addChromeDriver(MethodContextImpl context) {
        ChromeDriver driver = new ChromeDriver();
        context.setWebDriver((WebDriver)driver);
    }

    private static void addFirefoxDriver(MethodContextImpl context) {
    }

    private static void addInternetExplorerDriver(MethodContextImpl context) {
    }

    private static void addPhantomJSDriver(MethodContextImpl context) {
        DesiredCapabilities dcaps = new DesiredCapabilities();
        dcaps.setCapability("phantomjs.binary.path", phantomBinary.getAbsolutePath());
        if (context.getUserAgent() != null) {
            dcaps.setCapability("phantomjs.page.settings.userAgent", context.getUserAgent());
        }
        PhantomJSDriver driver = new PhantomJSDriver((Capabilities)dcaps);
        context.setWebDriver((WebDriver)driver);
    }

    private static Dimension getDimension(Method method, MethodContextImpl context) {
        if (method.isAnnotationPresent(Phone.class)) {
            Phone dimension = method.getAnnotation(Phone.class);
            context.setScreensize(dimension);
            return new Dimension(dimension.width(), dimension.height());
        }
        if (method.isAnnotationPresent(Tablet.class)) {
            Tablet dimension = method.getAnnotation(Tablet.class);
            context.setScreensize(dimension);
            return new Dimension(dimension.width(), dimension.height());
        }
        if (method.isAnnotationPresent(Desktop.class)) {
            Desktop dimension = method.getAnnotation(Desktop.class);
            context.setScreensize(dimension);
            return new Dimension(dimension.width(), dimension.height());
        }
        if (method.isAnnotationPresent(LargeDesktop.class)) {
            LargeDesktop dimension = method.getAnnotation(LargeDesktop.class);
            context.setScreensize(dimension);
            return new Dimension(dimension.width(), dimension.height());
        }
        return null;
    }

    private static class ScreenSizeHelper {
        private ScreenSizeHelper() {
        }

        @Phone
        static void phone() {
        }

        @Tablet
        static void tablet() {
        }

        @Desktop
        static void deskop() {
        }

        @LargeDesktop
        static void lagedeskop() {
        }
    }
}

