/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsdevel.testng.selenium;

import com.github.jsdevel.testng.selenium.MethodContext;
import com.github.jsdevel.testng.selenium.PageAssertions;
import com.github.jsdevel.testng.selenium.exceptions.PageInstantiationException;
import java.net.MalformedURLException;
import java.net.URL;
import org.openqa.selenium.WebDriver;
import org.testng.AssertJUnit;

public abstract class Page<P extends Page>
implements PageAssertions<P> {
    protected MethodContext context;
    protected String endpoint;
    protected URL url;
    protected WebDriver webDriver;

    @Override
    public P assertCurrentUrlPathStartsWith(String proposal) {
        URL currentUrl;
        this.context.log("Asserting that the current URL path starts with " + proposal);
        String currentWebDriverUrl = this.webDriver.getCurrentUrl();
        this.context.log("The current WebDriver URL is " + currentWebDriverUrl);
        try {
            currentUrl = new URL(currentWebDriverUrl);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
        this.context.log("The current WebDriver URL path is " + currentUrl.getPath());
        AssertJUnit.assertTrue((currentUrl.getPath().indexOf(proposal) == 0 ? 1 : 0) != 0);
        return (P)this;
    }

    protected abstract boolean assertPageIsViewableFrom(URL var1);

    protected void handlePageLoaded() {
    }

    void initialize(String desiredUrl, MethodContext context) {
        URL proposedUrl;
        this.context = context;
        this.endpoint = context.getEndpoint();
        this.webDriver = context.getWebDriver();
        try {
            proposedUrl = new URL(this.ofAbsoluteUrl(desiredUrl, this.endpoint));
        }
        catch (MalformedURLException e) {
            throw new PageInstantiationException(e);
        }
        this.url = proposedUrl;
        context.log("Initializing " + this.getClass().getSimpleName());
        if (this.webDriver.getCurrentUrl().equals("about:blank")) {
            context.log("Detected about:blank.");
            context.log("Navigating to " + proposedUrl);
            this.webDriver.get(proposedUrl.toString());
        }
        context.log("Asserting that the page is Viewable from " + proposedUrl);
        this.assertPageIsViewableFrom(proposedUrl);
        context.log("Emitting Page Loaded Event.");
        this.handlePageLoaded();
    }

    private String ofAbsoluteUrl(String proposedUrl, String defaultProtocolHost) {
        if (proposedUrl == null) {
            return defaultProtocolHost;
        }
        if (proposedUrl.matches("^[a-zA-Z]+://.+")) {
            return proposedUrl;
        }
        return defaultProtocolHost + "/" + proposedUrl.replaceFirst("^/+", "");
    }
}

