/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsdevel.testng.selenium.config;

import com.github.jsdevel.testng.selenium.config.ConfigDefaults;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

class PropertiesConfig {
    static final String DEBUG;
    static final String DRIVER;
    static final String ENDPOINT;
    static final String LOGGING_PREFIX;
    static final String SCREENSIZE;
    static final String TMPDIR;
    static final String USER_AGENT;

    PropertiesConfig() {
    }

    static {
        String debug = "disabled";
        String driver = "PhantomJS";
        String endpoint = ConfigDefaults.ENDPOINT;
        String loggingPrefix = "TestNG-Selenium";
        String screensize = "Phone";
        String tmpDir = ConfigDefaults.TMPDIR;
        String userAgent = ConfigDefaults.USER_AGENT;
        try (InputStream propertiesInputStream = PropertiesConfig.class.getResourceAsStream("/testng-selenium.properties");){
            if (propertiesInputStream != null) {
                try {
                    Properties properties = new Properties();
                    properties.load(propertiesInputStream);
                    debug = properties.getProperty("testng.selenium.debug", debug);
                    driver = properties.getProperty("testng.selenium.driver", driver);
                    endpoint = properties.getProperty("testng.selenium.endpoint", endpoint);
                    loggingPrefix = properties.getProperty("testng.selenium.logging_prefix", loggingPrefix);
                    screensize = properties.getProperty("testng.selenium.screensize", screensize);
                    tmpDir = properties.getProperty("testng.selenium.tmpdir", tmpDir);
                    userAgent = properties.getProperty("testng.selenium.driverconfig.useragent", userAgent);
                }
                catch (IOException e) {
                    Logger.getLogger(PropertiesConfig.class.getName()).log(Level.SEVERE, "Failed to load testng-selenium.properties.", e);
                    System.exit(1);
                }
            }
        }
        catch (IOException e) {
            Logger.getLogger(PropertiesConfig.class.getName()).log(Level.SEVERE, "Failed to close testng-selenium.properties.", e);
            System.exit(1);
        }
        DEBUG = debug;
        DRIVER = driver;
        ENDPOINT = endpoint;
        LOGGING_PREFIX = loggingPrefix;
        SCREENSIZE = screensize;
        TMPDIR = tmpDir;
        USER_AGENT = userAgent;
    }
}

