/*
 * Decompiled with CFR 0.152.
 */
package com.joutvhu.dynamic.jpa.query;

import com.joutvhu.dynamic.jpa.DynamicQuery;
import com.joutvhu.dynamic.jpa.query.DynamicJpaQueryMethod;
import com.joutvhu.dynamic.jpa.query.DynamicJpaRepositoryQuery;
import java.lang.reflect.Method;
import javax.persistence.EntityManager;
import org.springframework.data.jpa.provider.QueryExtractor;
import org.springframework.data.jpa.repository.query.EscapeCharacter;
import org.springframework.data.jpa.repository.query.JpaQueryLookupStrategy;
import org.springframework.data.jpa.repository.query.JpaQueryMethodFactory;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class DynamicJpaQueryLookupStrategy
implements QueryLookupStrategy {
    private final EntityManager entityManager;
    private QueryExtractor extractor;
    private QueryLookupStrategy jpaQueryLookupStrategy;
    private QueryMethodEvaluationContextProvider evaluationContextProvider;

    public DynamicJpaQueryLookupStrategy(EntityManager entityManager, JpaQueryMethodFactory queryMethodFactory, @Nullable QueryLookupStrategy.Key key, QueryExtractor extractor, QueryMethodEvaluationContextProvider evaluationContextProvider, EscapeCharacter escape) {
        this.jpaQueryLookupStrategy = JpaQueryLookupStrategy.create((EntityManager)entityManager, (JpaQueryMethodFactory)queryMethodFactory, (QueryLookupStrategy.Key)key, (QueryMethodEvaluationContextProvider)evaluationContextProvider, (EscapeCharacter)escape);
        this.extractor = extractor;
        this.entityManager = entityManager;
        this.evaluationContextProvider = evaluationContextProvider;
    }

    public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
        if (this.isMethodDynamicJpaHandle(method)) {
            DynamicJpaQueryMethod queryMethod = new DynamicJpaQueryMethod(method, metadata, factory, this.extractor);
            return new DynamicJpaRepositoryQuery(queryMethod, this.entityManager, this.evaluationContextProvider);
        }
        return this.jpaQueryLookupStrategy.resolveQuery(method, metadata, factory, namedQueries);
    }

    private boolean isMethodDynamicJpaHandle(Method method) {
        DynamicQuery annotation = method.getAnnotation(DynamicQuery.class);
        return annotation != null;
    }

    public static QueryLookupStrategy create(EntityManager entityManager, JpaQueryMethodFactory queryMethodFactory, @Nullable QueryLookupStrategy.Key key, QueryExtractor extractor, QueryMethodEvaluationContextProvider evaluationContextProvider, EscapeCharacter escape) {
        Assert.notNull((Object)entityManager, (String)"EntityManager must not be null!");
        Assert.notNull((Object)evaluationContextProvider, (String)"EvaluationContextProvider must not be null!");
        return new DynamicJpaQueryLookupStrategy(entityManager, queryMethodFactory, key, extractor, evaluationContextProvider, escape);
    }
}

