/*
 * Decompiled with CFR 0.152.
 */
package com.joutvhu.dynamic.commons.util;

import com.joutvhu.dynamic.commons.util.NamedTemplateCallback;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.Resource;

public class DynamicTemplateResolver {
    private final Resource resource;
    private List<String> lines;
    private String encoding = "UTF-8";

    public DynamicTemplateResolver(Resource resource) {
        this.resource = resource;
    }

    public static DynamicTemplateResolver of(Resource resource) {
        return new DynamicTemplateResolver(resource);
    }

    public static BufferedReader toBufferedReader(Reader reader) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public static List<String> readLines(InputStream input, String encoding) throws IOException {
        BufferedReader reader = DynamicTemplateResolver.toBufferedReader(new InputStreamReader(input, encoding == null ? Charset.defaultCharset() : Charset.forName(encoding)));
        ArrayList<String> list = new ArrayList<String>();
        String line = reader.readLine();
        while (line != null) {
            list.add(line);
            line = reader.readLine();
        }
        return list;
    }

    public DynamicTemplateResolver encoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    private boolean isNameLine(String line) {
        return StringUtils.startsWith((CharSequence)line, (CharSequence)"--");
    }

    private boolean isNameLine(int index) {
        return this.isNameLine(this.lines.get(index));
    }

    public void load(NamedTemplateCallback callback) throws Exception {
        InputStream inputStream = this.resource.getInputStream();
        this.lines = DynamicTemplateResolver.readLines(inputStream, this.encoding);
        int index = 0;
        String name = null;
        int total = this.lines.size();
        StringBuilder content = new StringBuilder();
        while (index < total) {
            do {
                String line;
                if (this.isNameLine(line = this.lines.get(index))) {
                    name = StringUtils.trim((String)StringUtils.substring((String)line, (int)2));
                    continue;
                }
                if ((line = StringUtils.trimToNull((String)line)) == null) continue;
                content.append(line).append(" ");
            } while (++index < total && !this.isNameLine(index));
            if (name != null) {
                callback.process(name, content.toString());
            }
            name = null;
            content = new StringBuilder();
        }
    }
}

