/*
 * Decompiled with CFR 0.152.
 */
package jnr.posix;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import jnr.constants.platform.Errno;
import jnr.posix.FileStat;
import jnr.posix.JavaFileStat;
import jnr.posix.JavaPOSIX;
import jnr.posix.JavaPasswd;
import jnr.posix.JavaSecuredFile;
import jnr.posix.POSIXHandler;
import jnr.posix.Passwd;
import jnr.posix.util.Chmod;
import jnr.posix.util.ExecIt;
import jnr.posix.util.FieldAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaLibCHelper {
    public static final int STDIN = 0;
    public static final int STDOUT = 1;
    public static final int STDERR = 2;
    private final POSIXHandler handler;
    private final Field fdField;
    private final Field handleField;
    private final Map<String, String> env;
    ThreadLocal<Integer> pwIndex = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };

    public JavaLibCHelper(POSIXHandler handler) {
        this.env = new HashMap<String, String>();
        this.handler = handler;
        this.handleField = FieldAccess.getProtectedField(FileDescriptor.class, "handle");
        this.fdField = FieldAccess.getProtectedField(FileDescriptor.class, "fd");
    }

    public int chmod(String filename, int mode) {
        return Chmod.chmod(new JavaSecuredFile(filename), Integer.toOctalString(mode));
    }

    public int chown(String filename, int user, int group) {
        ExecIt launcher = new ExecIt(this.handler);
        int chownResult = -1;
        int chgrpResult = -1;
        try {
            if (user != -1) {
                chownResult = launcher.runAndWait("chown", "" + user, filename);
            }
            if (group != -1) {
                chgrpResult = launcher.runAndWait("chgrp ", "" + user, filename);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return chownResult != -1 && chgrpResult != -1 ? 0 : 1;
    }

    public int getfd(FileDescriptor descriptor) {
        if (descriptor == null || this.fdField == null) {
            return -1;
        }
        try {
            return this.fdField.getInt(descriptor);
        }
        catch (SecurityException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return -1;
    }

    public long gethandle(FileDescriptor descriptor) {
        if (descriptor == null || this.handleField == null) {
            return -1L;
        }
        try {
            return this.handleField.getLong(descriptor);
        }
        catch (SecurityException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return -1L;
    }

    public String getlogin() {
        return System.getProperty("user.name");
    }

    public int getpid() {
        return this.handler.getPID();
    }

    public Passwd getpwent() {
        JavaPasswd retVal = this.pwIndex.get() == 0 ? new JavaPasswd(this.handler) : null;
        this.pwIndex.set(this.pwIndex.get() + 1);
        return retVal;
    }

    public int setpwent() {
        return 0;
    }

    public int endpwent() {
        this.pwIndex.set(0);
        return 0;
    }

    public Passwd getpwuid(int which) {
        return which == JavaPOSIX.LoginInfo.UID ? new JavaPasswd(this.handler) : null;
    }

    public int isatty(int fd) {
        return fd == 1 || fd == 0 || fd == 2 ? 1 : 0;
    }

    public int link(String oldpath, String newpath) {
        try {
            return new ExecIt(this.handler).runAndWait("ln", oldpath, newpath);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int lstat(String path, FileStat stat) {
        JavaSecuredFile file = new JavaSecuredFile(path);
        if (!((File)file).exists()) {
            this.handler.error(Errno.ENOENT, path);
        }
        JavaFileStat jstat = (JavaFileStat)stat;
        jstat.setup(path);
        return 0;
    }

    public int mkdir(String path, int mode) {
        JavaSecuredFile dir = new JavaSecuredFile(path);
        if (!((File)dir).mkdir()) {
            return -1;
        }
        this.chmod(path, mode);
        return 0;
    }

    public int rmdir(String path) {
        return new JavaSecuredFile(path).delete() ? 0 : -1;
    }

    public int stat(String path, FileStat stat) {
        JavaFileStat jstat = (JavaFileStat)stat;
        try {
            JavaSecuredFile file = new JavaSecuredFile(path);
            if (!((File)file).exists()) {
                this.handler.error(Errno.ENOENT, path);
            }
            jstat.setup(((File)file).getCanonicalPath());
        }
        catch (IOException e) {
            // empty catch block
        }
        return 0;
    }

    public int symlink(String oldpath, String newpath) {
        try {
            return new ExecIt(this.handler).runAndWait("ln", "-s", oldpath, newpath);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int readlink(String oldpath, ByteBuffer buffer, int length) throws IOException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            new ExecIt(this.handler).runAndWait(baos, "readlink", oldpath);
            byte[] bytes = baos.toByteArray();
            if (bytes.length > length || bytes.length == 0) {
                return -1;
            }
            buffer.put(bytes, 0, bytes.length - 1);
            return buffer.position();
        }
        catch (InterruptedException e) {
            return -1;
        }
    }

    public Map<String, String> getEnv() {
        return this.env;
    }
}

