/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlgrock.javascriptframework.mavenutils.pathing;

import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;

public final class RelativePath {
    private RelativePath() {
    }

    public static String getRelPathFromBase(File from, File to) throws IOException {
        int commonIndex;
        String normalizedTargetPath = FilenameUtils.normalizeNoEndSeparator((String)to.getCanonicalPath());
        String normalizedBasePath = FilenameUtils.normalizeNoEndSeparator((String)from.getCanonicalPath());
        if (File.separator.equals("/")) {
            normalizedTargetPath = FilenameUtils.separatorsToUnix((String)normalizedTargetPath);
            normalizedBasePath = FilenameUtils.separatorsToUnix((String)normalizedBasePath);
        } else if (File.separator.equals("\\")) {
            normalizedTargetPath = FilenameUtils.separatorsToWindows((String)normalizedTargetPath);
            normalizedBasePath = FilenameUtils.separatorsToWindows((String)normalizedBasePath);
        } else {
            throw new IllegalArgumentException("Unrecognised dir separator '" + File.separator + "'");
        }
        String[] base = normalizedBasePath.split(Pattern.quote(File.separator));
        String[] target = normalizedTargetPath.split(Pattern.quote(File.separator));
        StringBuffer common = new StringBuffer();
        for (commonIndex = 0; commonIndex < target.length && commonIndex < base.length && target[commonIndex].equals(base[commonIndex]); ++commonIndex) {
            common.append(target[commonIndex] + File.separator);
        }
        if (commonIndex == 0) {
            throw new IOException("No common path element found for '" + normalizedTargetPath + "' and '" + normalizedBasePath + "'");
        }
        boolean baseIsFile = true;
        File baseResource = new File(normalizedBasePath);
        if (baseResource.exists()) {
            baseIsFile = baseResource.isFile();
        }
        StringBuffer relative = new StringBuffer();
        if (base.length != commonIndex) {
            int numDirsUp = baseIsFile ? base.length - commonIndex - 1 : base.length - commonIndex;
            for (int i = 0; i < numDirsUp; ++i) {
                relative.append(".." + File.separator);
            }
        }
        relative.append(normalizedTargetPath.substring(common.length() - 1));
        String outputString = relative.toString().replace(File.separator + File.separator, File.separator);
        String outputStringReplaced = outputString.replace(File.separator, "/");
        return outputStringReplaced;
    }
}

