/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlgrock.javascriptframework.mavenutils.mavenobjects;

import java.io.File;

public final class JsarRelativeLocations {
    public static final String CLOSURE_LIBRARY_LOCATION = "closure-library";
    public static final String JSAR_TEST_LOCATION = "testDependencies";
    public static final String JSAR_TEST_SUITE_LOCATION = "testSuite";
    public static final String JSAR_COMPILED_TEST_SUITE_LOCATION = "testSuiteCompiled";
    public static final String JSAR_EXTERN_LOCATION = "externDependencies";
    public static final String JSAR_ASSERTION_SOURCE_LOCATION = "assertionSource";
    public static final String JSAR_PROCESSED_SOURCE_LOCATION = "debugSource";
    public static final String JSAR_INTERN_LOCATION = "internDependencies";
    public static final String JSAR_OUTPUT_LOCATION = "output";
    public static final String JSAR_COMPILE_LOCATION = "compiled";
    public static final String JSAR_ASSERT_LOCATION = "assert";
    public static final String JSAR_DEBUG_LOCATION = "debug";
    public static final String JSAR_TEST_DEPS_LOCATION = "testDeps";
    public static final String JSAR_ASSERT_REQUIRES_LOCATION = "assertRequires";
    public static final String JSAR_DEBUG_REQUIRES_LOCATION = "debugRequires";

    private JsarRelativeLocations() {
    }

    public static final File getClosureLibraryLocation(File frameworkLocation) {
        return new File(frameworkLocation, CLOSURE_LIBRARY_LOCATION);
    }

    public static final File getDebugDepsLocation(File frameworkLocation) {
        return new File(JsarRelativeLocations.getOutputLocation(frameworkLocation), JSAR_DEBUG_LOCATION);
    }

    public static final File getAssertDepsLocation(File frameworkLocation) {
        return new File(JsarRelativeLocations.getOutputLocation(frameworkLocation), JSAR_ASSERT_LOCATION);
    }

    public static final File getDebugRequiresLocation(File frameworkLocation) {
        return new File(JsarRelativeLocations.getOutputLocation(frameworkLocation), JSAR_DEBUG_REQUIRES_LOCATION);
    }

    public static final File getAssertRequiresLocation(File frameworkLocation) {
        return new File(JsarRelativeLocations.getOutputLocation(frameworkLocation), JSAR_ASSERT_REQUIRES_LOCATION);
    }

    public static final File getTestDepsLocation(File frameworkLocation) {
        return new File(frameworkLocation, JSAR_TEST_DEPS_LOCATION);
    }

    public static final File getTestLocation(File frameworkLocation) {
        return new File(frameworkLocation, JSAR_TEST_LOCATION);
    }

    public static final File getTestSuiteLocation(File frameworkLocation) {
        return new File(frameworkLocation, JSAR_TEST_SUITE_LOCATION);
    }

    public static final File getCompiledTestSuiteLocation(File frameworkLocation) {
        return new File(frameworkLocation, JSAR_COMPILED_TEST_SUITE_LOCATION);
    }

    public static final File getAssertionSourceLocation(File frameworkLocation) {
        return new File(JsarRelativeLocations.getOutputLocation(frameworkLocation), JSAR_ASSERTION_SOURCE_LOCATION);
    }

    public static final File getDebugSourceLocation(File frameworkLocation) {
        return new File(JsarRelativeLocations.getOutputLocation(frameworkLocation), JSAR_PROCESSED_SOURCE_LOCATION);
    }

    public static final File getExternsLocation(File frameworkLocation) {
        return new File(JsarRelativeLocations.getOutputLocation(frameworkLocation), JSAR_EXTERN_LOCATION);
    }

    public static final File getInternsLocation(File frameworkLocation) {
        return new File(frameworkLocation, JSAR_INTERN_LOCATION);
    }

    public static final File getInternsDebugLocation(File frameworkLocation) {
        return new File(JsarRelativeLocations.getInternsLocation(frameworkLocation), JSAR_PROCESSED_SOURCE_LOCATION);
    }

    public static final File getInternsAssertLocation(File frameworkLocation) {
        return new File(JsarRelativeLocations.getInternsLocation(frameworkLocation), JSAR_ASSERTION_SOURCE_LOCATION);
    }

    public static final File getOutputLocation(File frameworkLocation) {
        return new File(frameworkLocation, JSAR_OUTPUT_LOCATION);
    }

    public static final File getCompileLocation(File frameworkLocation) {
        return new File(JsarRelativeLocations.getOutputLocation(frameworkLocation), JSAR_COMPILE_LOCATION);
    }
}

