/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlgrock.javascriptframework.mavenutils.mavenobjects;

import com.github.jlgrock.javascriptframework.mavenutils.io.ZipUtils;
import com.github.jlgrock.javascriptframework.mavenutils.mavenobjects.PackagingType;
import com.github.jlgrock.javascriptframework.mavenutils.mavenobjects.ScopeType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;
import org.apache.maven.artifact.Artifact;

public class ArtifactExtractor {
    private static final Logger LOGGER = Logger.getLogger(ArtifactExtractor.class);
    private final Set<Artifact> artifacts;

    public ArtifactExtractor(Set<Artifact> artifactsIn) {
        this.artifacts = artifactsIn;
    }

    public final void extract(PackagingType packagingType, ScopeType scope, File outputDirectory) throws IOException {
        this.extract(null, packagingType, scope, outputDirectory);
    }

    public final void extract(String zipEntryName, PackagingType packagingType, ScopeType scope, File outputDirectory) throws IOException {
        LOGGER.debug((Object)("unfiltered artifacts size (" + (Object)((Object)packagingType) + ":" + (Object)((Object)scope) + ") : " + this.artifacts.size()));
        Set<Artifact> filteredArtifacts = this.filterArtifactList(packagingType, scope);
        LOGGER.debug((Object)("filtered artifacts size (" + (Object)((Object)packagingType) + "/" + (Object)((Object)scope) + "): " + filteredArtifacts.size()));
        if (zipEntryName != null) {
            this.extractSet(zipEntryName, filteredArtifacts, outputDirectory);
        } else {
            this.extractSet(filteredArtifacts, outputDirectory);
        }
    }

    private void extractSet(Set<? extends Artifact> filteredArtifacts, File outputDirectory) throws IOException {
        this.extractSet(null, filteredArtifacts, outputDirectory);
    }

    private void extractSet(String zipEntryName, Set<? extends Artifact> filteredArtifacts, File outputDirectory) throws IOException {
        for (Artifact artifact : filteredArtifacts) {
            LOGGER.debug((Object)("Processing artifact \"" + artifact.getArtifactId() + "\""));
            File file = artifact.getFile();
            FileInputStream is = new FileInputStream(file);
            ZipInputStream zis = new ZipInputStream(is);
            if (zipEntryName == null) {
                ZipUtils.unzip(zis, outputDirectory);
                continue;
            }
            ZipUtils.unzip(zis, zipEntryName, outputDirectory);
        }
    }

    private Set<Artifact> filterArtifactList(PackagingType packagingType, ScopeType scopeType) {
        LinkedHashSet<Artifact> returnArtifacts = new LinkedHashSet<Artifact>();
        for (Artifact a : this.artifacts) {
            PackagingType artifactPackagingType;
            ScopeType artifactScopeType = ScopeType.getByName(a.getScope());
            if (artifactScopeType == null) {
                artifactScopeType = ScopeType.COMPILE;
            }
            if ((artifactPackagingType = PackagingType.getByName(a.getType())) == null) {
                artifactPackagingType = PackagingType.JAR;
            }
            if (!scopeType.equals((Object)artifactScopeType) && !scopeType.equals((Object)ScopeType.ANY) || !packagingType.equals((Object)artifactPackagingType) && !packagingType.equals((Object)PackagingType.ANY)) continue;
            returnArtifacts.add(a);
        }
        return returnArtifacts;
    }
}

