/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlgrock.javascriptframework.mavenutils.logging;

import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.logging.Log;

public class MojoLogAppender
extends AppenderSkeleton {
    private static Log mavenLog;

    public static void beginLogging(AbstractMojo mojo) {
        mavenLog = mojo.getLog();
    }

    public static void endLogging() {
        mavenLog = null;
    }

    protected final void append(LoggingEvent event) {
        if (mavenLog == null) {
            return;
        }
        Level level = event.getLevel();
        if (Level.DEBUG.equals((Object)level) && !mavenLog.isDebugEnabled()) {
            return;
        }
        String text = this.layout.format(event);
        Throwable throwable = null;
        if (event.getThrowableInformation() != null) {
            throwable = event.getThrowableInformation().getThrowable();
        }
        if (Level.DEBUG.equals((Object)level)) {
            if (throwable != null) {
                mavenLog.debug((CharSequence)text, throwable);
            } else {
                mavenLog.debug((CharSequence)text);
            }
        } else if (Level.INFO.equals((Object)level)) {
            if (throwable != null) {
                mavenLog.info((CharSequence)text, throwable);
            } else {
                mavenLog.info((CharSequence)text);
            }
        } else if (Level.WARN.equals((Object)level)) {
            if (throwable != null) {
                mavenLog.warn((CharSequence)text, throwable);
            } else {
                mavenLog.warn((CharSequence)text);
            }
        } else if (Level.ERROR.equals((Object)level) || Level.FATAL.equals((Object)level)) {
            if (throwable != null) {
                mavenLog.error((CharSequence)text, throwable);
            } else {
                mavenLog.error((CharSequence)text);
            }
        } else if (throwable != null) {
            mavenLog.error((CharSequence)text, throwable);
        } else {
            mavenLog.error((CharSequence)text);
        }
    }

    public final void close() {
        mavenLog = null;
    }

    public final boolean requiresLayout() {
        return true;
    }
}

