/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlgrock.javascriptframework.closuretesting;

import java.io.File;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractClosureTestingMojo
extends AbstractMojo {
    private static final Logger LOGGER = Logger.getLogger(AbstractClosureTestingMojo.class);
    @Parameter(property="testSourceDirectory", defaultValue="${basedir}${file.separator}src${file.separator}test${file.separator}javascript")
    private File testSourceDirectory;
    @Parameter(property="frameworkTargetDirectory", defaultValue="${project.build.directory}${file.separator}javascriptFramework")
    private File frameworkTargetDirectory;
    @Parameter(property="closureLibraryLocation", defaultValue="${project.build.directory}/javascriptFramework/closure-library")
    private File closureLibraryLocation;
    @Parameter(property="compiledFilename", defaultValue="${project.build.finalName}-min.js", required=true)
    private String compiledFilename;
    @Parameter(property="skipTests", defaultValue="false")
    protected boolean skipTests;
    @Parameter(property="maven.test.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(property="runTestsOnCompiled", defaultValue="false")
    private boolean runTestsOnCompiled;
    private List<File> excludes;
    private List<File> includes;
    @Parameter(property="preamble")
    private String preamble;
    @Parameter(property="prologue")
    private String prologue;
    @Parameter(property="epilogue")
    private String epilogue;
    @Parameter(property="maximumFailures", defaultValue="5")
    private int maximumFailures;
    @Parameter(property="testTimeoutSeconds", defaultValue="10")
    private long testTimeoutSeconds;
    @Parameter(property="maxTestThreads", defaultValue="-1")
    private int maxTestThreads;
    @Parameter(property="testTimeoutSeconds")
    private String browserVersion;

    public final long getTestTimeoutSeconds() {
        return this.testTimeoutSeconds;
    }

    public String getBrowserVersion() {
        return this.browserVersion;
    }

    public final int getMaxTestThreads() {
        int max;
        int restrictedMax = Math.max(1, Runtime.getRuntime().availableProcessors() - 1);
        if (this.maxTestThreads < 1) {
            max = restrictedMax;
        } else if (this.maxTestThreads > restrictedMax) {
            LOGGER.warn((Object)String.format("A maximum of %d test threads may be used on this system.  (%d requested)", restrictedMax, this.maxTestThreads));
            max = restrictedMax;
        } else {
            max = this.maxTestThreads;
        }
        return max;
    }

    public final File getTestSourceDirectory() {
        return this.testSourceDirectory;
    }

    public final File getFrameworkTargetDirectory() {
        return this.frameworkTargetDirectory;
    }

    public final File getClosureLibraryLocation() {
        return this.closureLibraryLocation;
    }

    public final boolean isSkipTests() {
        return this.skipTests;
    }

    public final boolean isSkip() {
        return this.skip;
    }

    public final List<File> getExcludes() {
        return this.excludes;
    }

    public final List<File> getIncludes() {
        return this.includes;
    }

    public final boolean isRunTestsOnCompiled() {
        return this.runTestsOnCompiled;
    }

    public final String getCompiledFilename() {
        return this.compiledFilename;
    }

    public final String getPreamble() {
        return this.preamble;
    }

    public final String getPrologue() {
        return this.prologue;
    }

    public final String getEpilogue() {
        return this.epilogue;
    }

    public abstract void execute() throws MojoExecutionException, MojoFailureException;

    public final int getMaximumFailures() {
        return this.maximumFailures;
    }
}

