/*
 * Decompiled with CFR 0.152.
 */
package org.repackage.io.vavr.collection;

import java.util.function.IntUnaryOperator;
import org.repackage.io.vavr.collection.Collections;
import org.repackage.io.vavr.collection.IndexedSeq;
import org.repackage.io.vavr.collection.Vector;

interface IndexedSeqModule {

    public static interface Search {
        public static <T> int binarySearch(IndexedSeq<T> seq, IntUnaryOperator comparison) {
            int low = 0;
            int high = seq.size() - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                int cmp = comparison.applyAsInt(mid);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return -(low + 1);
        }
    }

    public static class Slice {
        static <T> int indexOfSlice(IndexedSeq<T> source, Iterable<? extends T> slice, int from) {
            if (source.isEmpty()) {
                return from == 0 && Collections.isEmpty(slice) ? 0 : -1;
            }
            IndexedSeq<T> _slice = Slice.toIndexedSeq(slice);
            int maxIndex = source.length() - _slice.length();
            return Slice.findSlice(source, _slice, Math.max(from, 0), maxIndex);
        }

        static <T> int lastIndexOfSlice(IndexedSeq<T> source, Iterable<? extends T> slice, int end) {
            if (end < 0) {
                return -1;
            }
            if (source.isEmpty()) {
                return Collections.isEmpty(slice) ? 0 : -1;
            }
            if (Collections.isEmpty(slice)) {
                int len = source.length();
                return len < end ? len : end;
            }
            int index = 0;
            int result = -1;
            IndexedSeq<T> _slice = Slice.toIndexedSeq(slice);
            int maxIndex = source.length() - _slice.length();
            while (index <= maxIndex) {
                int indexOfSlice = Slice.findSlice(source, _slice, index, maxIndex);
                if (indexOfSlice < 0) {
                    return result;
                }
                if (indexOfSlice <= end) {
                    result = indexOfSlice;
                    index = indexOfSlice + 1;
                    continue;
                }
                return result;
            }
            return result;
        }

        private static <T> int findSlice(IndexedSeq<T> source, IndexedSeq<T> slice, int index, int maxIndex) {
            while (index <= maxIndex) {
                if (source.startsWith(slice, index)) {
                    return index;
                }
                ++index;
            }
            return -1;
        }

        private static <T> IndexedSeq<T> toIndexedSeq(Iterable<? extends T> iterable) {
            return iterable instanceof IndexedSeq ? (Vector<? extends T>)iterable : Vector.ofAll(iterable);
        }
    }
}

