/*
 * Decompiled with CFR 0.152.
 */
package org.repackage.com.github.jlangch.aviron.limiter;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.repackage.com.github.jlangch.aviron.limiter.ClamdCpuLimiter;
import org.repackage.com.github.jlangch.aviron.util.service.Service;

public class ScheduledClamdCpuLimiter
extends Service {
    private final ClamdCpuLimiter limiter;
    private final long initialDelay;
    private final long period;
    private final TimeUnit unit;
    private final ScheduledExecutorService es;

    public ScheduledClamdCpuLimiter(ClamdCpuLimiter limiter, long initialDelay, long period, TimeUnit unit) {
        this.limiter = limiter;
        this.initialDelay = initialDelay;
        this.period = period;
        this.unit = unit;
        this.es = Executors.newScheduledThreadPool(1);
        if (unit.toSeconds(period) < 60L) {
            throw new IllegalArgumentException("The specified scheduler period must not be less than 60s");
        }
    }

    @Override
    protected String name() {
        return "ScheduledClamdCpuLimiter";
    }

    @Override
    protected void onStart() {
        this.es.scheduleAtFixedRate(() -> this.updateCpuLimit(this.limiter), this.initialDelay, this.period, this.unit);
    }

    @Override
    protected void onClose() {
        try {
            this.es.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateCpuLimit(ClamdCpuLimiter limiter) {
        limiter.activateClamdCpuLimit();
    }
}

