/*
 * Decompiled with CFR 0.152.
 */
package org.repackage.com.github.jlangch.aviron.limiter;

import java.time.LocalDateTime;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.repackage.com.github.jlangch.aviron.Clamd;
import org.repackage.com.github.jlangch.aviron.events.ClamdCpuLimitChangeEvent;
import org.repackage.com.github.jlangch.aviron.impl.util.StringUtils;
import org.repackage.com.github.jlangch.aviron.limiter.DynamicCpuLimit;

public class ClamdCpuLimiter {
    public static final int MIN_SCAN_LIMIT_PERCENT = 20;
    private Limit lastSeen = new Limit(null, -1);
    private final Clamd clamd;
    private final AtomicBoolean mocking = new AtomicBoolean(false);
    private final AtomicReference<Consumer<ClamdCpuLimitChangeEvent>> limitChangeListener = new AtomicReference();
    private final DynamicCpuLimit dynamicCpuLimit;

    public ClamdCpuLimiter(Clamd clamd, DynamicCpuLimit dynamicCpuLimit) {
        this.clamd = clamd;
        this.dynamicCpuLimit = dynamicCpuLimit == null ? new DynamicCpuLimit() : dynamicCpuLimit;
    }

    public void setClamdCpuLimitChangeListener(Consumer<ClamdCpuLimitChangeEvent> listener) {
        this.limitChangeListener.set(listener);
    }

    public Clamd getClamd() {
        return this.clamd;
    }

    public void mocking(boolean mock) {
        this.mocking.set(mock);
    }

    public int getLimitForTimestamp(LocalDateTime timestamp) {
        return this.dynamicCpuLimit.computeCpuLimit(timestamp);
    }

    public synchronized int getLastSeenLimit() {
        return this.lastSeen.limit;
    }

    public synchronized boolean activateClamdCpuLimit(int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException("A limit value must not be negative!");
        }
        if (!this.mocking.get()) {
            String pid = this.clamd.getPid();
            if (!StringUtils.isBlank(pid)) {
                Limit newLimit = new Limit(pid, limit);
                if (Objects.equals(pid, this.lastSeen.pid) && limit == this.lastSeen.limit) {
                    return false;
                }
                ClamdCpuLimitChangeEvent event = new ClamdCpuLimitChangeEvent(this.lastSeen.limit, limit);
                this.lastSeen = newLimit;
                this.clamd.activateCpuLimit(Math.max(20, limit));
                this.fireEvent(event);
                return true;
            }
        } else {
            if (limit == this.lastSeen.limit) {
                return false;
            }
            this.fireEvent(new ClamdCpuLimitChangeEvent(this.lastSeen.limit, limit));
            this.lastSeen = new Limit(null, limit);
            return true;
        }
        return false;
    }

    public synchronized boolean activateClamdCpuLimit() {
        int limit = this.dynamicCpuLimit.computeCpuLimit();
        return this.activateClamdCpuLimit(limit);
    }

    public synchronized void deactivateClamdCpuLimit() {
        ClamdCpuLimitChangeEvent event = new ClamdCpuLimitChangeEvent(this.lastSeen.limit, 100);
        this.lastSeen = new Limit(null, 100);
        if (!this.mocking.get()) {
            this.clamd.deactivateCpuLimit();
        }
        this.fireEvent(event);
    }

    public String formatProfilesAsTableByHour() {
        return this.dynamicCpuLimit.formatProfilesAsTableByHour();
    }

    public String toString() {
        return this.dynamicCpuLimit.toString();
    }

    private void fireEvent(ClamdCpuLimitChangeEvent event) {
        Consumer<ClamdCpuLimitChangeEvent> listener = this.limitChangeListener.get();
        if (listener != null) {
            ClamdCpuLimiter.safeRun(() -> listener.accept(event));
        }
    }

    private static void safeRun(Runnable r) {
        try {
            r.run();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class Limit {
        private final String pid;
        private final int limit;
        private final LocalDateTime ts;

        public Limit(String pid, int limit) {
            this.pid = pid;
            this.limit = limit;
            this.ts = LocalDateTime.now();
        }

        public String toString() {
            return String.format("pid=%s, limit=%d, ts=%s", this.pid, this.limit, this.ts.toString());
        }
    }
}

