/*
 * Decompiled with CFR 0.152.
 */
package org.repackage.com.github.jlangch.aviron.impl.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CollectionUtils {
    public static <U> List<U> toList(U object) {
        ArrayList<U> list = new ArrayList<U>();
        if (object != null) {
            list.add(object);
        }
        return list;
    }

    public static <U> List<U> toUnmodifiableList(U object) {
        return Collections.unmodifiableList(CollectionUtils.toList(object));
    }

    @SafeVarargs
    public static <U> List<U> toList(U ... objects) {
        return objects == null ? new ArrayList() : Arrays.asList(objects);
    }

    @SafeVarargs
    public static <U> List<U> toUnmodifiableList(U ... objects) {
        return Collections.unmodifiableList(CollectionUtils.toList(objects));
    }

    public static <U> Set<U> toSet(U object) {
        HashSet<U> set = new HashSet<U>();
        if (object != null) {
            set.add(object);
        }
        return set;
    }

    public static <U> Set<U> toUnmodifiableSet(U object) {
        return Collections.unmodifiableSet(CollectionUtils.toSet(object));
    }

    @SafeVarargs
    public static <U> Set<U> toSet(U ... objects) {
        HashSet<U> set = new HashSet<U>();
        if (objects != null) {
            for (U obj : objects) {
                set.add(obj);
            }
        }
        return set;
    }

    @SafeVarargs
    public static <U> Set<U> toUnmodifiableSet(U ... objects) {
        return Collections.unmodifiableSet(CollectionUtils.toSet(objects));
    }

    public static <T> List<T> toEmpty(List<T> list) {
        return list == null ? new ArrayList() : list;
    }

    public static <U> U first(List<U> items) {
        return items.isEmpty() ? null : (U)items.get(0);
    }

    public static <U> U second(List<U> items) {
        return items.size() < 2 ? null : (U)items.get(1);
    }

    public static <U> U third(List<U> items) {
        return items.size() < 3 ? null : (U)items.get(2);
    }
}

