/*
 * Decompiled with CFR 0.152.
 */
package org.repackage.com.github.jlangch.aviron.impl.quarantine;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.time.LocalDateTime;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.repackage.com.github.jlangch.aviron.dto.QuarantineFile;
import org.repackage.com.github.jlangch.aviron.dto.ScanResult;
import org.repackage.com.github.jlangch.aviron.events.QuarantineEvent;
import org.repackage.com.github.jlangch.aviron.events.QuarantineFileAction;
import org.repackage.com.github.jlangch.aviron.ex.QuarantineException;
import org.repackage.com.github.jlangch.aviron.ex.QuarantineFileActionException;
import org.repackage.com.github.jlangch.aviron.impl.quarantine.Hashes;
import org.repackage.com.github.jlangch.aviron.impl.util.StringUtils;

public class Quarantine {
    private static final String HASH_ALGO = "MD5";
    private static final String HASH_SALT = "ClamAV Aviron";
    private final QuarantineFileAction quarantineFileAction;
    private final File quarantineDir;
    private final Consumer<QuarantineEvent> listener;
    private final boolean listenerSupplied;

    public Quarantine(QuarantineFileAction quarantineFileAction, File quarantineDir, Consumer<QuarantineEvent> listener) {
        this.quarantineFileAction = quarantineFileAction;
        this.quarantineDir = quarantineDir;
        this.listener = listener == null ? e -> {} : listener;
        this.listenerSupplied = listener != null;
    }

    public boolean isActive() {
        return this.quarantineFileAction != QuarantineFileAction.NONE;
    }

    public QuarantineFileAction getQuarantineFileAction() {
        return this.quarantineFileAction;
    }

    public File getQuarantineDir() {
        return this.quarantineDir;
    }

    public boolean hasListener() {
        return this.listenerSupplied;
    }

    public void handleQuarantineActions(ScanResult result) {
        if (this.quarantineFileAction == QuarantineFileAction.NONE || result == null || result.isOK()) {
            return;
        }
        result.getVirusFound().entrySet().stream().forEach(e -> this.processQuarantineAction(new File((String)e.getKey()), (List)e.getValue()));
    }

    public List<QuarantineFile> listQuarantineFiles() {
        try {
            return Files.list(this.quarantineDir.toPath()).map(p -> p.toFile().getPath()).filter(f -> !f.endsWith(".virus")).sorted().map(f -> new File(f + ".virus")).map(f -> QuarantineFile.from(f)).collect(Collectors.toList());
        }
        catch (Exception ex) {
            throw new QuarantineException("Failed to list quarantine files", ex);
        }
    }

    public void removeQuarantineFile(QuarantineFile file) {
        if (file == null) {
            throw new IllegalArgumentException("A 'file' must not be null!");
        }
        String filename = file.getQuarantineFileName();
        if (StringUtils.isBlank(filename)) {
            throw new IllegalArgumentException("The field 'quarantineFileName' in the 'file' must not be empty!");
        }
        File qFile = new File(this.quarantineDir, filename);
        File qInfoFile = new File(this.quarantineDir, filename + ".virus");
        boolean qFileDeleted = qFile.delete();
        boolean qInfoFileDeleted = qInfoFile.delete();
        if (!qFileDeleted && !qInfoFileDeleted) {
            throw new QuarantineException("The quarantine file \u00ab" + filename + "\u00bb could not be deleted");
        }
        if (!qFileDeleted || !qInfoFileDeleted) {
            throw new QuarantineException("The quarantine file \u00ab" + filename + "\u00bb could not be completely deleted");
        }
    }

    public void removeAllQuarantineFiles() {
        try {
            this.listQuarantineFiles().forEach(f -> this.removeQuarantineFile((QuarantineFile)f));
        }
        catch (Exception ex) {
            throw new QuarantineException("Failed to remove all quarantine files", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processQuarantineAction(File file, List<String> virusList) {
        if (!file.isFile() || !file.canRead()) {
            return;
        }
        Quarantine quarantine = this;
        synchronized (quarantine) {
            File destFile = null;
            File destInfoFile = null;
            try {
                destFile = this.makeUniqueQuarantineFileName(file);
                destInfoFile = this.makeUniqueQuarantineInfoFileName(destFile);
                if (this.quarantineFileAction == QuarantineFileAction.MOVE) {
                    Files.move(file.toPath(), destFile.toPath(), StandardCopyOption.ATOMIC_MOVE);
                } else if (this.quarantineFileAction == QuarantineFileAction.COPY) {
                    if (this.existsAlready(file, virusList)) {
                        return;
                    }
                    Files.copy(file.toPath(), destFile.toPath(), StandardCopyOption.COPY_ATTRIBUTES);
                }
                this.makeQuarantineInfoFile(destFile, destInfoFile, file, virusList, this.quarantineFileAction);
                try {
                    this.listener.accept(new QuarantineEvent(file, virusList, destFile, this.quarantineFileAction, null));
                }
                catch (RuntimeException runtimeException) {}
            }
            catch (Exception ex) {
                try {
                    this.listener.accept(new QuarantineEvent(file, virusList, destFile, this.quarantineFileAction, new QuarantineFileActionException("Failed to process quarantine action", ex)));
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }
    }

    private File makeUniqueQuarantineFileName(File file) {
        String name = file.getName();
        File destFile = new File(this.quarantineDir, name);
        if (!destFile.isFile()) {
            return destFile;
        }
        for (int ii = 1; ii <= 100; ++ii) {
            destFile = new File(this.quarantineDir, name + "." + ii);
            if (destFile.isFile()) continue;
            return destFile;
        }
        throw new QuarantineFileActionException("Failed to find unique quarantine file name for infected file \u00ab" + file + "\u00bb. Infected file not moved/copied to quarantine dir!");
    }

    private File makeUniqueQuarantineInfoFileName(File file) {
        return new File(file.getParentFile(), file.getName() + ".virus");
    }

    private void makeQuarantineInfoFile(File quarantineFile, File quarantineInfoFile, File infectedFile, List<String> virusList, QuarantineFileAction action) {
        try {
            QuarantineFile qf = new QuarantineFile(quarantineFile.getName(), infectedFile, virusList, action, LocalDateTime.now(), action == QuarantineFileAction.MOVE ? this.hashFile(quarantineFile) : this.hashFile(infectedFile));
            Files.write(quarantineInfoFile.toPath(), qf.format().getBytes(Charset.defaultCharset()), StandardOpenOption.CREATE);
        }
        catch (Exception ex) {
            throw new QuarantineFileActionException("Failed to create quarantine info file name for infected file \u00ab" + infectedFile + "\u00bb!", ex);
        }
    }

    private boolean existsAlready(File infectedFile, List<String> virusList) {
        return this.listQuarantineFiles().stream().anyMatch(f -> f.getInfectedFile().equals(infectedFile) && f.getHash().equals(this.hashFile(infectedFile)));
    }

    private String hashFile(File file) {
        return Hashes.hashFile(HASH_ALGO, HASH_SALT, file);
    }
}

