/*
 * Decompiled with CFR 0.152.
 */
package org.repackage.com.github.jlangch.aviron.impl.commands;

import org.repackage.com.github.jlangch.aviron.ex.UnknownCommandException;
import org.repackage.com.github.jlangch.aviron.impl.commands.CommandDef;
import org.repackage.com.github.jlangch.aviron.impl.commands.CommandFormat;
import org.repackage.com.github.jlangch.aviron.impl.server.ClamdServerIO;

public abstract class Command<T> {
    public abstract CommandDef getCommandDef();

    public final String getCommandString() {
        return this.getCommandDef().getCommandString();
    }

    public final CommandFormat getFormat() {
        return this.getCommandDef().getFormat();
    }

    public T send(ClamdServerIO server) {
        String rawResponse = server.sendCommandAndReturnResponse(this.rawCommand());
        String response = this.removeResponseTerminator(rawResponse);
        if ("UNKNOWN COMMAND".equals(response)) {
            throw new UnknownCommandException(this.getCommandString());
        }
        return this.parseResponse(response);
    }

    protected String rawCommand() {
        return String.format("%s%s%s", Character.valueOf(this.getFormat().getPrefix()), this.getCommandString(), Character.valueOf(this.getFormat().getTerminator()));
    }

    protected abstract T parseResponse(String var1);

    protected String removeResponseTerminator(String response) {
        int index = response.lastIndexOf(this.getFormat().getTerminator());
        return index >= 0 ? response.substring(0, index) : response;
    }
}

