/*
 * Decompiled with CFR 0.152.
 */
package org.repackage.com.github.jlangch.aviron.filewatcher;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.repackage.com.github.jlangch.aviron.events.FileWatchErrorEvent;
import org.repackage.com.github.jlangch.aviron.events.FileWatchFileEvent;
import org.repackage.com.github.jlangch.aviron.events.FileWatchFileEventType;
import org.repackage.com.github.jlangch.aviron.events.FileWatchTerminationEvent;
import org.repackage.com.github.jlangch.aviron.filewatcher.FsWatchMonitor;
import org.repackage.com.github.jlangch.aviron.filewatcher.IFileWatcher;
import org.repackage.com.github.jlangch.aviron.impl.util.CollectionUtils;
import org.repackage.com.github.jlangch.aviron.util.service.Service;

public class FileWatcher_FsWatch
extends Service
implements IFileWatcher {
    public static final String HOMEBREW_FSWATCH_PROGRAM = "/opt/homebrew/bin/fswatch";
    private static final String SEPARATOR = "|#|";
    private final AtomicReference<Process> fswatchProcess = new AtomicReference();
    private final Path mainDir;
    private final boolean recursive;
    private final FsWatchMonitor monitor;
    private final String fswatchProgram;
    private final AtomicReference<Predicate<FileWatchFileEvent>> fileSelector = new AtomicReference();
    private final AtomicReference<Consumer<FileWatchFileEvent>> fileListener = new AtomicReference();
    private final AtomicReference<Consumer<FileWatchErrorEvent>> errorListener = new AtomicReference();
    private final AtomicReference<Consumer<FileWatchTerminationEvent>> terminationListener = new AtomicReference();

    public FileWatcher_FsWatch(Path mainDir, boolean recursive, FsWatchMonitor monitor, String fswatchProgram) {
        this(mainDir, recursive, null, null, null, monitor, fswatchProgram);
    }

    public FileWatcher_FsWatch(Path mainDir, boolean recursive, Consumer<FileWatchFileEvent> fileListener, Consumer<FileWatchErrorEvent> errorListener, Consumer<FileWatchTerminationEvent> terminationListener, FsWatchMonitor monitor, String fswatchProgram) {
        if (mainDir == null) {
            throw new IllegalArgumentException("The mainDir must not be null!");
        }
        if (!Files.isDirectory(mainDir, new LinkOption[0])) {
            throw new RuntimeException("The main dir " + mainDir + " does not exist or is not a directory");
        }
        if (fswatchProgram != null && !Files.isExecutable(Paths.get(fswatchProgram, new String[0]))) {
            throw new IllegalArgumentException("The fswatch Program does not exist or is not executable!");
        }
        this.mainDir = mainDir.toAbsolutePath().normalize();
        this.recursive = recursive;
        this.fileListener.set(fileListener);
        this.errorListener.set(errorListener);
        this.terminationListener.set(terminationListener);
        this.monitor = monitor;
        this.fswatchProgram = fswatchProgram == null ? "fswatch" : fswatchProgram;
    }

    @Override
    public Path getMainDir() {
        return this.mainDir;
    }

    @Override
    public List<Path> getRegisteredPaths() {
        return CollectionUtils.toList(this.mainDir);
    }

    @Override
    public void setFileSelector(Predicate<FileWatchFileEvent> selector) {
        this.fileSelector.set(selector);
    }

    @Override
    public void setFileListener(Consumer<FileWatchFileEvent> listener) {
        this.fileListener.set(listener);
    }

    @Override
    public void setErrorListener(Consumer<FileWatchErrorEvent> listener) {
        this.errorListener.set(listener);
    }

    @Override
    public void setTerminationListener(Consumer<FileWatchTerminationEvent> listener) {
        this.terminationListener.set(listener);
    }

    @Override
    protected String name() {
        return "FileWatcher_FsWatch";
    }

    @Override
    protected void onStart() {
        ArrayList<String> options = new ArrayList<String>();
        options.add(this.fswatchProgram);
        options.add("--format=%p|#|%f");
        if (this.monitor != null) {
            options.add("--monitor=" + this.monitor.name());
        }
        if (this.recursive) {
            options.add("-r");
        }
        options.add(this.mainDir.toString());
        ProcessBuilder pb = new ProcessBuilder(options.toArray(new String[0]));
        pb.redirectErrorStream(true);
        try {
            this.fswatchProcess.set(pb.start());
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to start 'fswatch' process", ex);
        }
        this.startServiceThread(this.createWorker());
        this.waitForServiceStarted(5);
    }

    @Override
    protected void onClose() throws IOException {
        Process process = this.fswatchProcess.get();
        if (process != null && process.isAlive()) {
            process.destroyForcibly();
        }
        this.fireEvent(new FileWatchTerminationEvent(this.mainDir));
    }

    private Runnable createWorker() {
        return () -> {
            try {
                Process process = this.fswatchProcess.get();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                    int ch;
                    StringBuilder buffer = new StringBuilder();
                    this.enteredRunningState();
                    while ((ch = reader.read()) != -1 && this.isInRunningState()) {
                        if (ch == 10) {
                            String line = buffer.toString();
                            buffer.setLength(0);
                            if (this.isIdleEvent(line)) continue;
                            int separatorIdx = line.indexOf(SEPARATOR);
                            if (separatorIdx != -1) {
                                String filePath = line.substring(0, separatorIdx);
                                Path path = Paths.get(filePath, new String[0]).normalize();
                                String flags = line.substring(separatorIdx + SEPARATOR.length());
                                Set<FileWatchFileEventType> types = this.mapToEventTypes(flags);
                                boolean isDir = flags.contains("IsDir");
                                boolean isFile = flags.contains("IsFile");
                                this.fireFileEvents(path, isDir, isFile, types);
                                continue;
                            }
                            Path path = Paths.get(line, new String[0]);
                            this.fireFallbackFileEvents(path);
                            continue;
                        }
                        buffer.append((char)ch);
                    }
                }
            }
            catch (Exception ex) {
                this.fireEvent(new FileWatchErrorEvent(this.mainDir, ex));
            }
            if (!this.isInClosedState()) {
                this.close();
            }
        };
    }

    private void fireFileEvents(Path path, boolean isDir, boolean isFile, Set<FileWatchFileEventType> types) {
        if (isDir) {
            if (types.contains((Object)FileWatchFileEventType.DELETED)) {
                this.fireEvent(new FileWatchFileEvent(path, isDir, isFile, FileWatchFileEventType.DELETED));
            } else if (types.contains((Object)FileWatchFileEventType.CREATED)) {
                this.fireEvent(new FileWatchFileEvent(path, isDir, isFile, FileWatchFileEventType.CREATED));
            }
        } else if (isFile) {
            if (Files.isRegularFile(path, new LinkOption[0])) {
                if (types.contains((Object)FileWatchFileEventType.DELETED)) {
                    this.fireEvent(new FileWatchFileEvent(path, isDir, isFile, FileWatchFileEventType.DELETED));
                } else if (types.contains((Object)FileWatchFileEventType.MODIFIED)) {
                    this.fireEvent(new FileWatchFileEvent(path, isDir, isFile, FileWatchFileEventType.MODIFIED));
                } else if (types.contains((Object)FileWatchFileEventType.CREATED)) {
                    this.fireEvent(new FileWatchFileEvent(path, isDir, isFile, FileWatchFileEventType.CREATED));
                }
            } else if (types.contains((Object)FileWatchFileEventType.DELETED)) {
                this.fireEvent(new FileWatchFileEvent(path, isDir, isFile, FileWatchFileEventType.DELETED));
            } else {
                this.fireEvent(new FileWatchFileEvent(path, isDir, isFile, FileWatchFileEventType.MODIFIED));
            }
        }
    }

    private void fireFallbackFileEvents(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            this.fireEvent(new FileWatchFileEvent(path, true, false, FileWatchFileEventType.MODIFIED));
        } else if (Files.isRegularFile(path, new LinkOption[0])) {
            this.fireEvent(new FileWatchFileEvent(path, false, true, FileWatchFileEventType.MODIFIED));
        } else {
            this.fireEvent(new FileWatchFileEvent(path, false, false, FileWatchFileEventType.DELETED));
        }
    }

    private void fireEvent(FileWatchFileEvent event) {
        Consumer<FileWatchFileEvent> listener;
        Predicate<FileWatchFileEvent> selector = this.fileSelector.get();
        if ((selector == null || selector.test(event)) && (listener = this.fileListener.get()) != null) {
            FileWatcher_FsWatch.safeRun(() -> listener.accept(event));
        }
    }

    private void fireEvent(FileWatchErrorEvent event) {
        Consumer<FileWatchErrorEvent> listener = this.errorListener.get();
        if (listener != null) {
            FileWatcher_FsWatch.safeRun(() -> listener.accept(event));
        }
    }

    private void fireEvent(FileWatchTerminationEvent event) {
        Consumer<FileWatchTerminationEvent> listener = this.terminationListener.get();
        if (listener != null) {
            FileWatcher_FsWatch.safeRun(() -> listener.accept(event));
        }
    }

    private boolean isIdleEvent(String line) {
        return line.matches(" *NoOp *");
    }

    private Set<FileWatchFileEventType> mapToEventTypes(String flags) {
        return Arrays.stream(flags.split(" ")).map(s -> this.mapToEventType((String)s)).filter(e -> e != null).collect(Collectors.toSet());
    }

    private FileWatchFileEventType mapToEventType(String flag) {
        switch (flag) {
            case "PlatformSpecific": {
                return null;
            }
            case "Created": {
                return FileWatchFileEventType.CREATED;
            }
            case "Updated": {
                return FileWatchFileEventType.MODIFIED;
            }
            case "Removed": {
                return FileWatchFileEventType.DELETED;
            }
            case "Renamed": {
                return null;
            }
            case "OwnerModified": {
                return null;
            }
            case "AttributeModified": {
                return null;
            }
            case "MovedFrom": {
                return null;
            }
            case "MovedTo": {
                return null;
            }
            case "IsFile": {
                return null;
            }
            case "IsDir": {
                return null;
            }
            case "IsSymLink": {
                return null;
            }
            case "Link": {
                return null;
            }
            case "Overflow": {
                return FileWatchFileEventType.OVERFLOW;
            }
        }
        return null;
    }

    private static void safeRun(Runnable r) {
        try {
            r.run();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

