/*
 * Decompiled with CFR 0.152.
 */
package org.repackage.com.github.jlangch.aviron.examples;

import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.repackage.com.github.jlangch.aviron.Clamd;
import org.repackage.com.github.jlangch.aviron.Client;
import org.repackage.com.github.jlangch.aviron.FileSeparator;
import org.repackage.com.github.jlangch.aviron.dto.ScanResult;
import org.repackage.com.github.jlangch.aviron.events.ClamdCpuLimitChangeEvent;
import org.repackage.com.github.jlangch.aviron.events.QuarantineEvent;
import org.repackage.com.github.jlangch.aviron.events.QuarantineFileAction;
import org.repackage.com.github.jlangch.aviron.ex.AvironException;
import org.repackage.com.github.jlangch.aviron.impl.util.CollectionUtils;
import org.repackage.com.github.jlangch.aviron.limiter.ClamdCpuLimiter;
import org.repackage.com.github.jlangch.aviron.limiter.CpuProfile;
import org.repackage.com.github.jlangch.aviron.limiter.DynamicCpuLimit;
import org.repackage.com.github.jlangch.aviron.util.DemoFilestore;
import org.repackage.com.github.jlangch.aviron.util.DirCycler;
import org.repackage.com.github.jlangch.aviron.util.Util;

public class ClamdCpuLimiterExample1 {
    private static final boolean MOCKING = true;
    private static final int MIN_SCAN_LIMIT_PERCENT = 20;
    private final AtomicBoolean stop = new AtomicBoolean(false);

    public static void main(String[] args) {
        try {
            new ClamdCpuLimiterExample1().scan();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void scan() throws Exception {
        Util.printfln("Starting %s...", "in MOCKING mode ");
        try (DemoFilestore demoFS = new DemoFilestore();){
            demoFS.populateWithDemoFiles(5, 10);
            demoFS.createEicarAntiMalwareTestFile("001");
            Client client = new Client.Builder().mocking(true).serverHostname("localhost").serverFileSeparator(FileSeparator.UNIX).quarantineFileAction(QuarantineFileAction.MOVE).quarantineDir(demoFS.getQuarantineDir()).quarantineEventListener(this::onQuarantineEvent).build();
            if (!client.waitForOperationalClamd(1L, TimeUnit.MINUTES)) {
                throw new AvironException("Clamd is not ready!");
            }
            CpuProfile everyday = CpuProfile.of("weekday", CollectionUtils.toList("00:00-05:59 @ 100%", "06:00-07:59 @   0%", "08:00-17:59 @  50%", "18:00-21:59 @  50%", "22:00-23:59 @ 100%"));
            Clamd clamd = new Clamd(demoFS.getClamdPidFile());
            ClamdCpuLimiter limiter = new ClamdCpuLimiter(clamd, new DynamicCpuLimit(everyday));
            limiter.setClamdCpuLimitChangeListener(this::onCpuLimitChangeEvent);
            limiter.mocking(true);
            DirCycler fsDirCycler = new DirCycler(demoFS.getFilestoreDir());
            Util.printfln("Processing ...", new Object[0]);
            while (!this.stop.get()) {
                limiter.activateClamdCpuLimit();
                int limit = limiter.getLastSeenLimit();
                if (limit >= 20) {
                    this.onScanDir(fsDirCycler.nextDir(), client, demoFS);
                    Thread.sleep(10000L);
                    continue;
                }
                Util.printfln("Scanning currently paused by CPU profile", new Object[0]);
                Thread.sleep(30000L);
            }
            Util.printfln("Stopped", new Object[0]);
        }
    }

    private void onScanDir(File dir, Client client, DemoFilestore demoFS) {
        Util.printfln("Scanning dir: %s", dir.toPath());
        ScanResult result = client.scan(dir.toPath(), true);
        this.printVirusInfo(result, demoFS.countQuarantineFiles());
    }

    private void onCpuLimitChangeEvent(ClamdCpuLimitChangeEvent event) {
        Util.printfln("Adjusted %s", event);
    }

    private void onQuarantineEvent(QuarantineEvent event) {
        if (event.getException() != null) {
            Util.printfln("   Error %s", event.getException().getMessage());
        } else {
            Util.printfln("   Quarantined file: %s", event.getInfectedFile());
        }
    }

    private void printVirusInfo(ScanResult result, long quarantineCount) {
        if (result.hasVirus()) {
            result.getVirusFound().forEach((k, v) -> Util.printfln("   Virus detected:   %s -> %s", CollectionUtils.first(v), k));
            Util.printfln("   Quarantine count: %d", quarantineCount);
        }
    }
}

