/*
 * Decompiled with CFR 0.152.
 */
package org.repackage.com.github.jlangch.aviron;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.List;
import java.util.function.Supplier;
import org.repackage.com.github.jlangch.aviron.ex.AvironException;
import org.repackage.com.github.jlangch.aviron.impl.util.Shell;
import org.repackage.com.github.jlangch.aviron.impl.util.Signal;
import org.repackage.com.github.jlangch.aviron.impl.util.StringUtils;

public class Clamd {
    private final String pidStatic;
    private final File pidFile;
    private final Supplier<String> pidSupplier;

    public Clamd(String pid) {
        if (StringUtils.isBlank(pid)) {
            throw new IllegalArgumentException("A pid must not be blank!");
        }
        this.pidStatic = pid;
        this.pidFile = null;
        this.pidSupplier = null;
    }

    public Clamd(File pidFile) {
        if (pidFile == null) {
            throw new IllegalArgumentException("A pidFile must not be null!");
        }
        this.pidStatic = null;
        this.pidFile = pidFile;
        this.pidSupplier = null;
    }

    public Clamd(Supplier<String> pidSupplier) {
        if (pidSupplier == null) {
            throw new IllegalArgumentException("A pidSupplier must not be null!");
        }
        this.pidStatic = null;
        this.pidFile = null;
        this.pidSupplier = pidSupplier;
    }

    public String getPid() {
        Shell.validateLinuxOrMacOSX("ClamdPid::getPid");
        String pid = this.getRawPid();
        return StringUtils.isBlank(pid) ? null : (Shell.isProcessAlive(pid) ? pid : null);
    }

    public boolean isProcessAlive() {
        Shell.validateLinuxOrMacOSX("ClamdPid::isProcessAlive");
        String pid = this.getRawPid();
        return StringUtils.isBlank(pid) ? null : Boolean.valueOf(Shell.isProcessAlive(pid));
    }

    public void activateCpuLimit(int limit) {
        Shell.validateLinuxOrMacOSX("ClamdPid::activateCpuLimit");
        String pid = this.getRawPid();
        if (StringUtils.isNotBlank(pid)) {
            this.deactivateCpuLimit(pid);
            this.activateCpuLimit(pid, limit);
        }
    }

    public void deactivateCpuLimit() {
        Shell.validateLinuxOrMacOSX("ClamdPid::deactivateCpuLimit");
        String pid = this.getRawPid();
        if (StringUtils.isNotBlank(pid)) {
            this.deactivateCpuLimit(pid);
        }
    }

    public void kill() {
        Shell.validateLinuxOrMacOSX("ClamdPid::kill");
        String pid = this.getRawPid();
        if (StringUtils.isNotBlank(pid)) {
            Shell.kill(Signal.SIGTERM, pid);
        }
    }

    public static List<String> getCpulimitPids() {
        Shell.validateLinuxOrMacOSX("ClamdPid::getCpulimitPids");
        return Shell.pgrep("cpulimit");
    }

    public static List<String> getPids() {
        Shell.validateLinuxOrMacOSX("ClamdPid::getPids");
        return Shell.pgrep("clamd");
    }

    public static int getNrOfCpus() {
        return Runtime.getRuntime().availableProcessors();
    }

    private String getRawPid() {
        if (this.pidFile != null) {
            return this.loadFromPidFile(this.pidFile);
        }
        if (this.pidSupplier != null) {
            try {
                return this.pidSupplier.get();
            }
            catch (Exception ex) {
                return null;
            }
        }
        return this.pidStatic;
    }

    private void deactivateCpuLimit(String pid) {
        try {
            Shell.execCmd("pkill", "-f", "cpulimit.*" + pid);
        }
        catch (IOException ex) {
            throw new AvironException("Failed to deactivate CPU limit on the clamd process with the PID " + pid, ex);
        }
    }

    private void activateCpuLimit(String pid, int limit) {
        if (limit != 100) {
            try {
                Shell.execCmdBackgroundNohup("cpulimit", "--limit=" + limit, "--pid=" + pid);
            }
            catch (IOException ex) {
                throw new AvironException("Failed to activate a CPU limit of " + limit + "% on the clamd process with the PID " + pid, ex);
            }
        }
    }

    private String loadFromPidFile(File pidFile) {
        try {
            if (pidFile.isFile() && pidFile.canRead()) {
                return Files.lines(pidFile.toPath(), Charset.defaultCharset()).map(l -> l.trim()).findFirst().orElse(null);
            }
            return null;
        }
        catch (Exception ex) {
            throw new AvironException("Failed to load PID from file \u00ab" + pidFile + "\u00bb", ex);
        }
    }
}

