/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.ipc.impl.util;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.functions.CoreFunctions;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.util.json.VncJsonReader;
import com.github.jlangch.venice.impl.util.json.VncJsonWriter;
import com.github.jlangch.venice.nanojson.JsonAppendableWriter;
import com.github.jlangch.venice.nanojson.JsonReader;
import com.github.jlangch.venice.nanojson.JsonWriter;

public class Json {
    public static VncVal readJson(String json, boolean mapKeysToKeywords) {
        try {
            return new VncJsonReader(JsonReader.from(json), mapKeysToKeywords ? t -> CoreFunctions.keyword.applyOf((VncVal)t) : null, null, false).read();
        }
        catch (Exception ex) {
            throw new VncException("Failed to parse JSON data to Venice data!", ex);
        }
    }

    public static String writeJson(VncVal val, boolean pretty) {
        StringBuilder sb = new StringBuilder();
        JsonAppendableWriter writer = pretty ? JsonWriter.indent("  ").on(sb) : JsonWriter.on(sb);
        new VncJsonWriter(writer, false).write(val).done();
        return sb.toString();
    }
}

