/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.ipc.impl.util;

import com.github.jlangch.venice.EofException;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.util.ipc.impl.util.ExceptionUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class IO {
    public static ByteBuffer readFrame(SocketChannel ch) {
        try {
            ByteBuffer len = ByteBuffer.allocate(4);
            IO.readFully(ch, len);
            len.flip();
            int n = len.getInt();
            if (n < 0 || n > 0x1000000) {
                throw new IOException("Bad length: " + n);
            }
            if (n == 0) {
                return ByteBuffer.allocate(0);
            }
            ByteBuffer data = ByteBuffer.allocate(n);
            IO.readFully(ch, data);
            data.flip();
            return data;
        }
        catch (VncException ex) {
            throw ex;
        }
        catch (IOException ex) {
            if (ExceptionUtil.isBrokenPipeException(ex)) {
                throw new VncException("Failed to read data from channel, channel was closed!", ex);
            }
            throw new VncException("Failed to read data from channel!", ex);
        }
    }

    public static void writeFrame(SocketChannel ch, ByteBuffer data) {
        try {
            if (data == null) {
                ByteBuffer len = ByteBuffer.allocate(4).putInt(0);
                len.flip();
                IO.writeFully(ch, len);
            } else {
                ByteBuffer len = ByteBuffer.allocate(4).putInt(data.remaining());
                len.flip();
                IO.writeFully(ch, len);
                IO.writeFully(ch, data);
            }
        }
        catch (VncException ex) {
            throw ex;
        }
        catch (Exception ex) {
            if (ExceptionUtil.isBrokenPipeException(ex)) {
                throw new VncException("Failed to write data to channel, channel was closed!", ex);
            }
            throw new VncException("Failed to write data to channel!", ex);
        }
    }

    public static void readFully(SocketChannel ch, ByteBuffer buf) {
        try {
            while (buf.hasRemaining()) {
                if (ch.read(buf) >= 0) continue;
                throw new EofException("Failed to read data from channel, channel EOF reached!");
            }
        }
        catch (VncException ex) {
            throw ex;
        }
        catch (Exception ex) {
            if (ExceptionUtil.isBrokenPipeException(ex)) {
                throw new VncException("Failed to read data from channel, channel was closed!", ex);
            }
            throw new VncException("Failed to read data from channel!", ex);
        }
    }

    public static void writeFully(SocketChannel ch, ByteBuffer buf) {
        try {
            while (buf.hasRemaining()) {
                ch.write(buf);
            }
        }
        catch (Exception ex) {
            if (ExceptionUtil.isBrokenPipeException(ex)) {
                throw new VncException("Failed to write data to channel, channel was closed!", ex);
            }
            throw new VncException("Failed to write data to channel!", ex);
        }
    }

    public static void safeClose(SocketChannel ch) {
        if (ch != null) {
            try {
                ch.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

