/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.ipc.impl;

import com.github.jlangch.venice.util.ipc.IMessage;
import com.github.jlangch.venice.util.ipc.impl.Message;
import com.github.jlangch.venice.util.ipc.impl.Protocol;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class TcpSubscriptionListener
implements Runnable {
    private final SocketChannel ch;
    private final Consumer<IMessage> handler;
    private final AtomicBoolean running = new AtomicBoolean(false);

    public TcpSubscriptionListener(SocketChannel ch, Consumer<IMessage> handler) {
        this.ch = ch;
        this.handler = handler;
    }

    public boolean isRunning() {
        return this.running.get();
    }

    @Override
    public void run() {
        try {
            try {
                this.running.set(true);
                while (true) {
                    Message msg;
                    if ((msg = Protocol.receiveMessage(this.ch)) == null) {
                        continue;
                    }
                    try {
                        this.handler.accept(msg);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception exception) {
                this.running.set(false);
            }
        }
        catch (Throwable throwable) {
            this.running.set(false);
            throw throwable;
        }
    }
}

