/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.ipc.impl;

import com.github.jlangch.venice.util.ipc.impl.IPublisher;
import com.github.jlangch.venice.util.ipc.impl.Message;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class Subscriptions {
    private final HashMap<IPublisher, Set<String>> subscriptions = new HashMap();

    public void addSubscription(String topic, IPublisher publisher) {
        HashSet<String> topics = new HashSet<String>();
        topics.add(topic);
        this.subscriptions.put(publisher, topics);
    }

    public void addSubscription(Set<String> topics, IPublisher publisher) {
        this.subscriptions.put(publisher, topics);
    }

    public void removeSubscriptions(IPublisher publisher) {
        this.subscriptions.remove(publisher);
    }

    public void publish(Message msg) {
        String topic = msg.getTopic();
        ArrayList<IPublisher> publishers = new ArrayList<IPublisher>(this.subscriptions.keySet());
        publishers.forEach(p -> {
            Set<String> topics = this.subscriptions.get(p);
            if (topics != null && topics.contains(topic)) {
                p.publish(msg);
            }
        });
    }

    public int getClientSubscriptionCount() {
        return this.subscriptions.size();
    }

    public int getTopicSubscriptionCount() {
        return this.subscriptions.values().stream().mapToInt(t -> t.size()).sum();
    }
}

