/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.ipc;

import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.util.ipc.IMessage;
import com.github.jlangch.venice.util.ipc.MessageType;
import com.github.jlangch.venice.util.ipc.ResponseStatus;
import com.github.jlangch.venice.util.ipc.impl.Message;
import com.github.jlangch.venice.util.ipc.impl.Topics;
import com.github.jlangch.venice.util.ipc.impl.util.Json;
import java.nio.charset.Charset;
import java.util.Objects;

public abstract class MessageFactory {
    public static IMessage text(String topic, String mimetype, String charset, String data) {
        Objects.requireNonNull(topic);
        Objects.requireNonNull(mimetype);
        Objects.requireNonNull(charset);
        Objects.requireNonNull(data);
        return new Message(MessageType.NULL, ResponseStatus.NULL, false, Topics.of(topic), mimetype, charset, data.getBytes(Charset.forName(charset)));
    }

    public static IMessage json(String topic, String charset, String json) {
        Objects.requireNonNull(topic);
        Objects.requireNonNull(charset);
        Objects.requireNonNull(json);
        return new Message(MessageType.NULL, ResponseStatus.NULL, false, Topics.of(topic), "application/json", charset, json.getBytes(Charset.forName(charset)));
    }

    public static IMessage binary(String topic, String mimetype, byte[] data) {
        Objects.requireNonNull(topic);
        Objects.requireNonNull(mimetype);
        Objects.requireNonNull(data);
        return new Message(MessageType.NULL, ResponseStatus.NULL, false, Topics.of(topic), mimetype, null, data);
    }

    public static IMessage venice(String topic, VncVal data) {
        Objects.requireNonNull(topic);
        Objects.requireNonNull(data);
        return MessageFactory.json(topic, "UTF-8", Json.writeJson(data, false));
    }

    public static IMessage hello() {
        return MessageFactory.text("hello", "text/plain", "UTF-8", "Hello!");
    }
}

