/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.excel;

import java.util.HashMap;
import java.util.Map;

public enum PaperSize {
    PRINTER_DEFAULT(0),
    LETTER(1),
    LETTER_SMALL_PAGESIZE(2),
    TABLOID(3),
    LEDGER(4),
    LEGAL(5),
    STATEMENT(6),
    EXECUTIVE(7),
    A3(8),
    A4(9),
    A4_SMALL(10),
    A5(11),
    B4(12),
    B5(13),
    FOLIO8(14),
    QUARTO(15),
    TEN_BY_FOURTEEN(16),
    ELEVEN_BY_SEVENTEEN(17),
    NOTE8(18),
    ENVELOPE_9(19),
    ENVELOPE_10(20),
    ENVELOPE_DL(27),
    ENVELOPE_CS(28),
    ENVELOPE_C5(28),
    ENVELOPE_C3(29),
    ENVELOPE_C4(30),
    ENVELOPE_C6(31),
    ENVELOPE_MONARCH(37),
    A4_EXTRA(53),
    A4_TRANSVERSE(55),
    A4_PLUS(60),
    LETTER_ROTATED(75),
    A4_ROTATED(77);

    private static final Map<Short, PaperSize> PAPER_SIZE_BY_LEGACY_API_VALUE;
    private final short legacyApiValue;

    private PaperSize(short legacyApiValue) {
        this.legacyApiValue = legacyApiValue;
    }

    public short getLegacyApiValue() {
        return this.legacyApiValue;
    }

    public static PaperSize getByShortValue(short legacyApiValue) {
        return PAPER_SIZE_BY_LEGACY_API_VALUE.get(legacyApiValue);
    }

    static {
        PAPER_SIZE_BY_LEGACY_API_VALUE = new HashMap<Short, PaperSize>();
        for (PaperSize size : PaperSize.values()) {
            PAPER_SIZE_BY_LEGACY_API_VALUE.put(size.legacyApiValue, size);
        }
    }
}

