/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.crypt;

import java.io.File;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.util.Base64;

public class FileHasher {
    public static String hashFile(String algorithm, String salt, File inputFile) throws Exception {
        byte[] fileData = Files.readAllBytes(inputFile.toPath());
        return FileHasher.hashFile(algorithm, salt, fileData);
    }

    public static String hashFile(String algorithm, String salt, byte[] fileData) throws Exception {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        md.reset();
        md.update(salt.getBytes("UTF-8"));
        md.update(fileData);
        return FileHasher.encodeBase64(md.digest());
    }

    public static boolean verifyFileHash(String algorithm, String salt, File inputFile, String hash) throws Exception {
        byte[] fileData = Files.readAllBytes(inputFile.toPath());
        return FileHasher.verifyFileHash(algorithm, salt, fileData, hash);
    }

    public static boolean verifyFileHash(String algorithm, String salt, byte[] fileData, String hash) throws Exception {
        String fileDataHash = FileHasher.hashFile(algorithm, salt, fileData);
        return hash.equals(fileDataHash);
    }

    public static String encodeBase64(byte[] data) {
        return Base64.getEncoder().encodeToString(data);
    }

    public static byte[] decodeBase64(String data) {
        return Base64.getDecoder().decode(data);
    }
}

