/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.crypt;

import com.github.jlangch.venice.util.crypt.Util;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class FileEncryptor_AES256_CBC {
    private static int SALT_LEN = 16;
    private static int IV_LEN = 16;

    public static boolean isSupported() {
        return true;
    }

    public static void encryptFileWithPassphrase(String passphrase, File inputFile, File outputFile) throws Exception {
        byte[] fileData = Files.readAllBytes(inputFile.toPath());
        byte[] encryptedData = FileEncryptor_AES256_CBC.encryptFileWithPassphrase(passphrase, fileData);
        Files.write(outputFile.toPath(), encryptedData, new OpenOption[0]);
    }

    public static byte[] encryptFileWithPassphrase(String passphrase, byte[] fileData) throws Exception {
        byte[] salt = new byte[SALT_LEN];
        new SecureRandom().nextBytes(salt);
        byte[] iv = new byte[IV_LEN];
        new SecureRandom().nextBytes(iv);
        byte[] key = Util.deriveKeyFromPassphrase(passphrase, salt, 65536, 256);
        byte[] encryptedData = FileEncryptor_AES256_CBC.processData(1, fileData, key, iv);
        byte[] outData = new byte[SALT_LEN + IV_LEN + encryptedData.length];
        System.arraycopy(salt, 0, outData, 0, SALT_LEN);
        System.arraycopy(iv, 0, outData, SALT_LEN, IV_LEN);
        System.arraycopy(encryptedData, 0, outData, SALT_LEN + IV_LEN, encryptedData.length);
        return outData;
    }

    public static void encryptFileWithKey(byte[] key, File inputFile, File outputFile) throws Exception {
        byte[] fileData = Files.readAllBytes(inputFile.toPath());
        byte[] encryptedData = FileEncryptor_AES256_CBC.encryptFileWithKey(key, fileData);
        Files.write(outputFile.toPath(), encryptedData, new OpenOption[0]);
    }

    public static byte[] encryptFileWithKey(byte[] key, byte[] fileData) throws Exception {
        byte[] iv = new byte[IV_LEN];
        new SecureRandom().nextBytes(iv);
        byte[] encryptedData = FileEncryptor_AES256_CBC.processData(1, fileData, key, iv);
        byte[] outData = new byte[IV_LEN + encryptedData.length];
        System.arraycopy(iv, 0, outData, 0, IV_LEN);
        System.arraycopy(encryptedData, 0, outData, IV_LEN, encryptedData.length);
        return outData;
    }

    public static void decryptFileWithPassphrase(String passphrase, File inputFile, File outputFile) throws Exception {
        byte[] fileData = Files.readAllBytes(inputFile.toPath());
        byte[] decryptedData = FileEncryptor_AES256_CBC.decryptFileWithPassphrase(passphrase, fileData);
        Files.write(outputFile.toPath(), decryptedData, new OpenOption[0]);
    }

    public static byte[] decryptFileWithPassphrase(String passphrase, byte[] fileData) throws Exception {
        byte[] salt = new byte[SALT_LEN];
        System.arraycopy(fileData, 0, salt, 0, SALT_LEN);
        byte[] iv = new byte[IV_LEN];
        System.arraycopy(fileData, SALT_LEN, iv, 0, IV_LEN);
        byte[] encryptedData = new byte[fileData.length - SALT_LEN - IV_LEN];
        System.arraycopy(fileData, SALT_LEN + IV_LEN, encryptedData, 0, encryptedData.length);
        byte[] key = Util.deriveKeyFromPassphrase(passphrase, salt, 65536, 256);
        byte[] decryptedData = FileEncryptor_AES256_CBC.processData(2, encryptedData, key, iv);
        return decryptedData;
    }

    public static void decryptFileWithKey(byte[] key, File inputFile, File outputFile) throws Exception {
        byte[] fileData = Files.readAllBytes(inputFile.toPath());
        byte[] decryptedData = FileEncryptor_AES256_CBC.decryptFileWithKey(key, fileData);
        Files.write(outputFile.toPath(), decryptedData, new OpenOption[0]);
    }

    public static byte[] decryptFileWithKey(byte[] key, byte[] fileData) throws Exception {
        byte[] iv = new byte[IV_LEN];
        System.arraycopy(fileData, 0, iv, 0, IV_LEN);
        byte[] encryptedData = new byte[fileData.length - IV_LEN];
        System.arraycopy(fileData, IV_LEN, encryptedData, 0, encryptedData.length);
        byte[] decryptedData = FileEncryptor_AES256_CBC.processData(2, encryptedData, key, iv);
        return decryptedData;
    }

    private static byte[] processData(int mode, byte[] data, byte[] key, byte[] iv) throws Exception {
        IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
        Cipher cipher = FileEncryptor_AES256_CBC.getCipherInstance();
        SecretKeySpec keySpec = new SecretKeySpec(key, "AES");
        cipher.init(mode, (Key)keySpec, ivParameterSpec);
        return cipher.doFinal(data);
    }

    private static Cipher getCipherInstance() throws Exception {
        return Cipher.getInstance(String.join((CharSequence)"/", "AES", "CBC", "PKCS5Padding"));
    }
}

