/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.xchart;

import com.github.jlangch.venice.impl.util.reflect.ReflectionAccessor;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.MemoryCacheImageOutputStream;

public final class XChartEncoder {
    private XChartEncoder() {
    }

    public static byte[] exportToBitmapWithDPI(Object xchart, String bitmapFormat, int DPI) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        XChartEncoder.exportToBitmapStreamWithDPI(xchart, os, bitmapFormat, DPI);
        os.flush();
        return os.toByteArray();
    }

    public static void exportToBitmapStreamWithDPI(Object xchart, OutputStream os, String bitmapFormat, int DPI) throws IOException {
        double scaleFactor = (double)DPI / 72.0;
        int chartWidth = (Integer)ReflectionAccessor.getBeanProperty(xchart, "width").getValue();
        int chartHeight = (Integer)ReflectionAccessor.getBeanProperty(xchart, "height").getValue();
        BufferedImage image = new BufferedImage((int)((double)chartWidth * scaleFactor), (int)((double)chartHeight * scaleFactor), 1);
        Graphics2D graphics2D = image.createGraphics();
        AffineTransform at = graphics2D.getTransform();
        at.scale(scaleFactor, scaleFactor);
        graphics2D.setTransform(at);
        ReflectionAccessor.invokeInstanceMethod(xchart, "paint", new Object[]{graphics2D, chartWidth, chartHeight});
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(bitmapFormat.toLowerCase());
        if (writers.hasNext()) {
            ImageWriter writer = writers.next();
            ImageWriteParam iwp = writer.getDefaultWriteParam();
            ImageTypeSpecifier typeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(1);
            IIOMetadata metadata = writer.getDefaultImageMetadata(typeSpecifier, iwp);
            if (metadata.isReadOnly() || !metadata.isStandardMetadataFormatSupported()) {
                throw new IllegalArgumentException("It is not possible to set the DPI on a bitmap with " + bitmapFormat + " format!! Try another format.");
            }
            XChartEncoder.setDPI(metadata, DPI);
            writer.setOutput(new MemoryCacheImageOutputStream(os));
            writer.write(null, new IIOImage(image, null, metadata), iwp);
            writer.dispose();
            os.flush();
        }
    }

    private static void setDPI(IIOMetadata metadata, int DPI) throws IIOInvalidTreeException {
        double dotsPerMilli = 1.0 * (double)DPI / 10.0 / 2.54;
        IIOMetadataNode horiz = new IIOMetadataNode("HorizontalPixelSize");
        horiz.setAttribute("value", Double.toString(dotsPerMilli));
        IIOMetadataNode vert = new IIOMetadataNode("VerticalPixelSize");
        vert.setAttribute("value", Double.toString(dotsPerMilli));
        IIOMetadataNode dim = new IIOMetadataNode("Dimension");
        dim.appendChild(horiz);
        dim.appendChild(vert);
        IIOMetadataNode root = new IIOMetadataNode("javax_imageio_1.0");
        root.appendChild(dim);
        metadata.mergeTree("javax_imageio_1.0", root);
    }
}

