/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.vavr;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.repackage.io.vavr.collection.Iterator;
import org.repackage.io.vavr.control.Option;

public class Iterators {
    public static <T> Iterator<T> iterate(final Supplier<? extends Option<? extends T>> supplier) {
        Objects.requireNonNull(supplier, "supplier is null");
        return new Iterator<T>(){
            private Option<? extends T> nextOption = null;

            @Override
            public boolean hasNext() {
                if (this.nextOption == null) {
                    this.nextOption = (Option)supplier.get();
                }
                return this.nextOption.isDefined();
            }

            @Override
            public String toString() {
                return this.stringPrefix() + "(" + (this.isEmpty() ? "" : "?") + ")";
            }

            @Override
            public final T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() on empty iterator");
                }
                Object next = this.nextOption.get();
                this.nextOption = null;
                return next;
            }
        };
    }

    public static <T> Iterator<T> iterate(final T seed, final Function<? super T, ? extends Option<? extends T>> fn) {
        Objects.requireNonNull(fn, "function is null");
        return new Iterator<T>(){
            private T last = null;
            private Option<? extends T> nextOption = Option.of(seed);

            @Override
            public boolean hasNext() {
                if (this.nextOption == null) {
                    this.nextOption = (Option)fn.apply(this.last);
                }
                return this.nextOption.isDefined();
            }

            @Override
            public String toString() {
                return this.stringPrefix() + "(" + (this.isEmpty() ? "" : "?") + ")";
            }

            @Override
            public final T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() on empty iterator");
                }
                Object next = this.nextOption.get();
                this.nextOption = null;
                this.last = next;
                return next;
            }
        };
    }
}

