/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.shell;

import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.shell.ShellResult;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;

public class ShellBackgroundResult {
    private final ShellResult startResult;
    private final File nohupFile;

    public ShellBackgroundResult(ShellResult startResult, File nohupFile) {
        this.startResult = startResult;
        this.nohupFile = nohupFile;
    }

    public ShellResult getStartResult() {
        return this.startResult;
    }

    public File getNohupFile() {
        return this.nohupFile;
    }

    public String getNohupFileText() {
        if (this.nohupFile.isFile()) {
            try {
                return new String(Files.readAllBytes(this.nohupFile.toPath()), Charset.forName("UTF-8"));
            }
            catch (IOException ex) {
                throw new RuntimeException("Faile to read nohup file", ex);
            }
        }
        return null;
    }

    public String toString() {
        if (this.nohupFile.isFile()) {
            StringBuilder sb = new StringBuilder(this.startResult.toString());
            String nohup = StringUtil.trimToNull(this.getNohupFileText());
            if (nohup == null) {
                sb.append("\n[nohup]   empty\n");
            } else {
                sb.append("\n[nohup]\n");
                sb.append(nohup);
            }
            return sb.toString();
        }
        return this.startResult.toString();
    }
}

