/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.reflect;

public class ScopedEnumValue {
    private final String scopedEnumValue;
    private final String enumValue;
    private final String enumClassName;
    private final String enumClassSimpleName;

    public ScopedEnumValue(String scopedEnumValue) {
        this.scopedEnumValue = scopedEnumValue;
        int p1 = scopedEnumValue.lastIndexOf(46);
        if (p1 > 0) {
            this.enumValue = scopedEnumValue.substring(p1 + 1);
            String className = scopedEnumValue.substring(0, p1);
            int p2 = className.lastIndexOf(46);
            if (p2 > 0) {
                this.enumClassSimpleName = className.substring(p2 + 1);
                this.enumClassName = className.substring(0, p2);
            } else {
                this.enumClassSimpleName = className;
                this.enumClassName = null;
            }
        } else {
            this.enumValue = scopedEnumValue;
            this.enumClassName = null;
            this.enumClassSimpleName = null;
        }
    }

    public String getScopedEnumValue() {
        return this.scopedEnumValue;
    }

    public String getEnumValue() {
        return this.enumValue;
    }

    public String getEnumClassName() {
        return this.enumClassName;
    }

    public String getEnumClassSimpleName() {
        return this.enumClassSimpleName;
    }

    public boolean isScoped() {
        return this.enumClassSimpleName != null;
    }

    public boolean isCompatible(Class<?> clazz) {
        return this.enumClassName != null && clazz.getName().equals(this.enumClassName) || this.enumClassSimpleName != null && clazz.getSimpleName().equals(this.enumClassSimpleName);
    }

    public Enum<?> getEnum(Class<? extends Enum<?>> clazz) {
        for (Enum<?> e : clazz.getEnumConstants()) {
            if (!this.enumValue.equals(e.name())) continue;
            return e;
        }
        return null;
    }
}

